/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty12;

import com.github.tomakehurst.wiremock.jetty.JettyHttpUtils;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import wiremock.jakarta.servlet.ServletResponse;
import wiremock.jakarta.servlet.http.HttpServletRequest;
import wiremock.jakarta.servlet.http.HttpServletResponse;
import wiremock.jakarta.servlet.http.HttpServletResponseWrapper;
import wiremock.org.eclipse.jetty.ee10.servlet.ServletApiResponse;
import wiremock.org.eclipse.jetty.io.EndPoint;
import wiremock.org.eclipse.jetty.io.SelectableChannelEndPoint;
import wiremock.org.eclipse.jetty.io.ssl.SslConnection;
import wiremock.org.eclipse.jetty.server.AbstractMetaDataConnection;
import wiremock.org.eclipse.jetty.server.Response;

public class Jetty12HttpUtils
implements JettyHttpUtils {
    @Override
    public Response unwrapResponse(ServletResponse httpServletResponse) {
        if (httpServletResponse instanceof HttpServletResponseWrapper) {
            ServletResponse unwrapped = ((HttpServletResponseWrapper)httpServletResponse).getResponse();
            return this.unwrapResponse(unwrapped);
        }
        return Jetty12HttpUtils.unwrap(httpServletResponse);
    }

    private static Response unwrap(ServletResponse wrapped) {
        if (wrapped instanceof Response) {
            return (Response)((Object)wrapped);
        }
        if (wrapped instanceof ServletApiResponse) {
            return ((ServletApiResponse)wrapped).getResponse();
        }
        throw new IllegalStateException("Cannot unwrap a" + Response.class.getName() + " from a " + wrapped.getClass().getName());
    }

    @Override
    public Socket socket(Response response) {
        AbstractMetaDataConnection connectionMetaData = (AbstractMetaDataConnection)response.getRequest().getConnectionMetaData();
        SelectableChannelEndPoint ep = (SelectableChannelEndPoint)connectionMetaData.getEndPoint();
        return ((SocketChannel)ep.getChannel()).socket();
    }

    @Override
    public Socket tlsSocket(Response response) {
        AbstractMetaDataConnection connectionMetaData = (AbstractMetaDataConnection)response.getRequest().getConnectionMetaData();
        SslConnection.SslEndPoint sslEndpoint = (SslConnection.SslEndPoint)connectionMetaData.getEndPoint();
        SelectableChannelEndPoint endpoint = (SelectableChannelEndPoint)sslEndpoint.getSslConnection().getEndPoint();
        return ((SocketChannel)endpoint.getChannel()).socket();
    }

    @Override
    public void setStatusWithReason(int status, String reason, HttpServletResponse httpServletResponse) {
        httpServletResponse.setStatus(status);
    }

    @Override
    public EndPoint unwrapEndPoint(Response jettyResponse) {
        AbstractMetaDataConnection connectionMetaData = (AbstractMetaDataConnection)jettyResponse.getRequest().getConnectionMetaData();
        return connectionMetaData.getEndPoint();
    }

    @Override
    public boolean isBrowserProxyRequest(HttpServletRequest request) {
        return Boolean.TRUE.equals(request.getAttribute("wiremock.isHttpsProxyRequest")) || Boolean.TRUE.equals(request.getAttribute("wiremock.isHttpProxyRequest"));
    }
}

