/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty11;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.ssl.ReadOnlyFileOrClasspathKeyStoreSource;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.EnumSet;

public class WritableFileOrClasspathKeyStoreSource
extends ReadOnlyFileOrClasspathKeyStoreSource {
    public WritableFileOrClasspathKeyStoreSource(String path, String keyStoreType, char[] keyStorePassword) {
        super(path, keyStoreType, keyStorePassword);
    }

    @Override
    public void save(KeyStore keyStore) {
        Path created = WritableFileOrClasspathKeyStoreSource.createKeystoreFile(Paths.get(this.path, new String[0]));
        try (FileOutputStream fos = new FileOutputStream(created.toFile());){
            keyStore.store(fos, this.keyStorePassword);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            Exceptions.throwUnchecked(e);
        }
    }

    private static Path createKeystoreFile(Path path) {
        FileAttribute[] privateDirAttrs = new FileAttribute[]{};
        FileAttribute[] privateFileAttrs = new FileAttribute[]{};
        if (FileSystems.getDefault().supportedFileAttributeViews().contains("posix")) {
            privateDirAttrs = new FileAttribute[]{PosixFilePermissions.asFileAttribute(EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE))};
            privateFileAttrs = new FileAttribute[]{PosixFilePermissions.asFileAttribute(EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE))};
        }
        try {
            if (!Files.exists(path.getParent(), new LinkOption[0])) {
                Files.createDirectories(path.getParent(), privateDirAttrs);
            }
            return Files.createFile(path, privateFileAttrs);
        }
        catch (IOException e) {
            return Exceptions.throwUnchecked(e, Path.class);
        }
    }
}

