/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.FatalStartupException;
import com.github.tomakehurst.wiremock.common.HttpsSettings;
import com.github.tomakehurst.wiremock.common.JettySettings;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.http.AdminRequestHandler;
import com.github.tomakehurst.wiremock.http.HttpServer;
import com.github.tomakehurst.wiremock.http.StubRequestHandler;
import com.github.tomakehurst.wiremock.http.ThreadPoolFactory;
import com.github.tomakehurst.wiremock.http.trafficlistener.WiremockNetworkTrafficListener;
import com.github.tomakehurst.wiremock.jetty.DefaultMultipartRequestConfigElementBuilder;
import com.github.tomakehurst.wiremock.jetty.QueuedThreadPoolFactory;
import com.github.tomakehurst.wiremock.servlet.MultipartRequestConfigElementBuilder;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import wiremock.org.eclipse.jetty.io.EndPoint;
import wiremock.org.eclipse.jetty.io.NetworkTrafficListener;
import wiremock.org.eclipse.jetty.server.Handler;
import wiremock.org.eclipse.jetty.server.Server;
import wiremock.org.eclipse.jetty.server.ServerConnector;

public abstract class JettyHttpServer
implements HttpServer {
    private static final AtomicBoolean STRICT_HTTP_HEADERS_APPLIED = new AtomicBoolean(false);
    private static final int MAX_RETRIES = 3;
    protected static final String FILES_URL_MATCH = String.format("/%s/*", "__files");
    protected static final String[] GZIPPABLE_METHODS = new String[]{"POST", "PUT", "PATCH", "DELETE"};
    protected final Options options;
    protected final Server jettyServer;
    protected final ServerConnector httpConnector;
    protected final ServerConnector httpsConnector;
    protected ScheduledExecutorService scheduledExecutorService;

    public JettyHttpServer(Options options, AdminRequestHandler adminRequestHandler, StubRequestHandler stubRequestHandler) {
        this.options = options;
        if (!options.getDisableStrictHttpHeaders() && Boolean.FALSE.equals(STRICT_HTTP_HEADERS_APPLIED.get())) {
            System.setProperty("wiremock.org.eclipse.jetty.http.HttpGenerator.STRICT", String.valueOf(true));
            STRICT_HTTP_HEADERS_APPLIED.set(true);
        }
        this.jettyServer = this.createServer(options);
        NetworkTrafficListenerAdapter networkTrafficListenerAdapter = new NetworkTrafficListenerAdapter(options.networkTrafficListener());
        if (options.getHttpDisabled()) {
            this.httpConnector = null;
        } else {
            this.httpConnector = this.createHttpConnector(options.bindAddress(), options.portNumber(), options.jettySettings(), networkTrafficListenerAdapter);
            this.jettyServer.addConnector(this.httpConnector);
        }
        if (options.httpsSettings().enabled()) {
            this.httpsConnector = this.createHttpsConnector(options.bindAddress(), options.httpsSettings(), options.jettySettings(), networkTrafficListenerAdapter);
            this.jettyServer.addConnector(this.httpsConnector);
        } else {
            this.httpsConnector = null;
        }
        this.applyAdditionalServerConfiguration(this.jettyServer, options);
        Handler handlers = this.createHandler(options, adminRequestHandler, stubRequestHandler);
        this.jettyServer.setHandler(handlers);
        this.finalizeSetup(options);
    }

    protected void applyAdditionalServerConfiguration(Server jettyServer, Options options) {
    }

    protected abstract Handler createHandler(Options var1, AdminRequestHandler var2, StubRequestHandler var3);

    protected void finalizeSetup(Options options) {
        if (options.jettySettings().getStopTimeout().isEmpty()) {
            this.jettyServer.setStopTimeout(1000L);
        }
    }

    protected Server createServer(Options options) {
        ThreadPoolFactory threadPoolFactory = options.threadPoolFactory() != null ? options.threadPoolFactory() : new QueuedThreadPoolFactory();
        Server server = new Server(threadPoolFactory.buildThreadPool(options));
        JettySettings jettySettings = options.jettySettings();
        Optional<Long> stopTimeout = jettySettings.getStopTimeout();
        stopTimeout.ifPresent(server::setStopTimeout);
        return server;
    }

    public Handler[] extensionHandlers() {
        return new Handler[0];
    }

    @Override
    public void start() {
        int retryCount = 0;
        while (retryCount < 3) {
            try {
                this.jettyServer.start();
                break;
            }
            catch (IOException bindException) {
                if (++retryCount < 3) continue;
                throw new FatalStartupException(bindException);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        long timeout = System.currentTimeMillis() + 30000L;
        while (!this.jettyServer.isStarted()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (System.currentTimeMillis() <= timeout) continue;
            throw new RuntimeException("Server took too long to start up.");
        }
    }

    @Override
    public void stop() {
        try {
            if (this.scheduledExecutorService != null) {
                this.scheduledExecutorService.shutdown();
            }
            if (this.httpConnector != null) {
                this.httpConnector.getConnectedEndPoints().forEach(EndPoint::close);
            }
            if (this.httpsConnector != null) {
                this.httpsConnector.getConnectedEndPoints().forEach(EndPoint::close);
            }
            this.jettyServer.stop();
            this.jettyServer.join();
        }
        catch (TimeoutException timeoutException) {
        }
        catch (Exception e) {
            Exceptions.throwUnchecked(e);
        }
    }

    @Override
    public boolean isRunning() {
        return this.jettyServer.isRunning();
    }

    @Override
    public int port() {
        return this.httpConnector.getLocalPort();
    }

    @Override
    public int httpsPort() {
        return this.httpsConnector.getLocalPort();
    }

    public long stopTimeout() {
        return this.jettyServer.getStopTimeout();
    }

    protected abstract ServerConnector createHttpConnector(String var1, int var2, JettySettings var3, NetworkTrafficListener var4);

    protected abstract ServerConnector createHttpsConnector(String var1, HttpsSettings var2, JettySettings var3, NetworkTrafficListener var4);

    protected MultipartRequestConfigElementBuilder buildMultipartRequestConfigurer() {
        return new DefaultMultipartRequestConfigElementBuilder();
    }

    private static class NetworkTrafficListenerAdapter
    implements NetworkTrafficListener {
        private final WiremockNetworkTrafficListener wiremockNetworkTrafficListener;

        NetworkTrafficListenerAdapter(WiremockNetworkTrafficListener wiremockNetworkTrafficListener) {
            this.wiremockNetworkTrafficListener = wiremockNetworkTrafficListener;
        }

        @Override
        public void opened(Socket socket) {
            this.wiremockNetworkTrafficListener.opened(socket);
        }

        @Override
        public void incoming(Socket socket, ByteBuffer bytes) {
            this.wiremockNetworkTrafficListener.incoming(socket, bytes);
        }

        @Override
        public void outgoing(Socket socket, ByteBuffer bytes) {
            this.wiremockNetworkTrafficListener.outgoing(socket, bytes);
        }

        @Override
        public void closed(Socket socket) {
            this.wiremockNetworkTrafficListener.closed(socket);
        }
    }
}

