/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.common.FatalStartupException;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.extension.Extensions;
import com.github.tomakehurst.wiremock.http.DefaultFactory;
import com.github.tomakehurst.wiremock.http.HttpServerFactory;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import wiremock.org.eclipse.jetty.util.Jetty;

public class HttpServerFactoryLoader {
    private final Options options;
    private final Extensions extensions;
    private final Supplier<List<HttpServerFactory>> serviceLoader;
    private final boolean isJetty12;

    public HttpServerFactoryLoader(Options options, Extensions extensions, Supplier<List<HttpServerFactory>> serviceLoader, boolean isJetty12) {
        this.options = options;
        this.extensions = extensions;
        this.serviceLoader = serviceLoader;
        this.isJetty12 = isJetty12;
    }

    public HttpServerFactory load() {
        List<HttpServerFactory> extensionCandidates = this.extensions.ofType(HttpServerFactory.class).values().stream().toList();
        if (!extensionCandidates.isEmpty()) {
            return HttpServerFactoryLoader.pickMostAppropriateFrom(extensionCandidates);
        }
        if (this.options.hasDefaultHttpServerFactory() && !this.isJetty12) {
            List<HttpServerFactory> serviceLoadedCandidates = this.serviceLoader.get();
            return HttpServerFactoryLoader.pickMostAppropriateFrom(serviceLoadedCandidates);
        }
        return this.options.httpServerFactory();
    }

    public static Supplier<List<HttpServerFactory>> systemServiceLoader() {
        return () -> ServiceLoader.load(Extension.class).stream().filter(extension -> HttpServerFactory.class.isAssignableFrom(extension.type())).map(e -> (HttpServerFactory)e.get()).collect(Collectors.toList());
    }

    private static HttpServerFactory pickMostAppropriateFrom(List<HttpServerFactory> candidates) {
        if (candidates.isEmpty()) {
            throw HttpServerFactoryLoader.couldNotFindSuitableServerException();
        }
        return candidates.size() > 1 ? candidates.stream().filter(factory -> !DefaultFactory.class.isAssignableFrom(factory.getClass())).findFirst().orElseThrow(HttpServerFactoryLoader::couldNotFindSuitableServerException) : candidates.get(0);
    }

    private static FatalStartupException couldNotFindSuitableServerException() {
        return new FatalStartupException("Jetty 12 is not present and no suitable HttpServerFactory extension was found. Please ensure that the classpath includes a WireMock extension that provides an HttpServerFactory implementation. See https://wiremock.org/docs/extending-wiremock/ for more information.");
    }

    public static boolean isJetty12() {
        try {
            return Jetty.VERSION.startsWith("12");
        }
        catch (Throwable e) {
            return false;
        }
    }
}

