/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.ssl.KeyStoreSettings;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class BrowserProxySettings {
    public static final String DEFAULT_CA_KEYSTORE_PATH = new File(System.getProperty("user.home") + File.separatorChar + ".wiremock" + File.separatorChar + "ca-keystore.jks" + File.separatorChar).getAbsolutePath();
    public static final String DEFAULT_CA_KESTORE_PASSWORD = "password";
    public static BrowserProxySettings DISABLED = new Builder().build();
    private final boolean enabled;
    private final boolean trustAllProxyTargets;
    private final List<String> trustedProxyTargets;
    private final KeyStoreSettings caKeyStoreSettings;

    public BrowserProxySettings(boolean enabled, boolean trustAllProxyTargets, List<String> trustedProxyTargets, KeyStoreSettings caKeyStoreSettings) {
        this.enabled = enabled;
        this.trustAllProxyTargets = trustAllProxyTargets;
        this.trustedProxyTargets = trustedProxyTargets;
        this.caKeyStoreSettings = caKeyStoreSettings;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public boolean trustAllProxyTargets() {
        return this.trustAllProxyTargets;
    }

    public List<String> trustedProxyTargets() {
        return this.trustedProxyTargets;
    }

    public KeyStoreSettings caKeyStore() {
        return this.caKeyStoreSettings;
    }

    public String toString() {
        return "BrowserProxySettings{enabled=" + this.enabled + ", trustAllProxyTargets=" + this.trustAllProxyTargets + ", trustedProxyTargets=" + String.valueOf(this.trustedProxyTargets) + ", caKeyStore='" + this.caKeyStoreSettings.path() + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrowserProxySettings that = (BrowserProxySettings)o;
        return this.enabled == that.enabled && this.trustAllProxyTargets == that.trustAllProxyTargets && Objects.equals(this.trustedProxyTargets, that.trustedProxyTargets) && Objects.equals(this.caKeyStoreSettings, that.caKeyStoreSettings);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.trustAllProxyTargets, this.trustedProxyTargets, this.caKeyStoreSettings);
    }

    public static final class Builder {
        private boolean enabled = false;
        private boolean trustAllProxyTargets = false;
        private List<String> trustedProxyTargets = Collections.emptyList();
        private KeyStoreSettings caKeyStoreSettings = KeyStoreSettings.NO_STORE;

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder trustAllProxyTargets(boolean trustAllProxyTargets) {
            this.trustAllProxyTargets = trustAllProxyTargets;
            return this;
        }

        public Builder trustedProxyTargets(List<String> trustedProxyTargets) {
            this.trustedProxyTargets = trustedProxyTargets;
            return this;
        }

        public Builder caKeyStoreSettings(KeyStoreSettings caKeyStoreSettings) {
            this.caKeyStoreSettings = caKeyStoreSettings;
            return this;
        }

        public BrowserProxySettings build() {
            return new BrowserProxySettings(this.enabled, this.trustAllProxyTargets, this.trustedProxyTargets, this.caKeyStoreSettings);
        }
    }
}

