/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.xml;

import java.lang.module.Configuration;
import java.lang.module.ModuleFinder;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import wiremock.org.eclipse.jetty.util.annotation.Name;
import wiremock.org.eclipse.jetty.util.component.Environment;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class EnvironmentBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(EnvironmentBuilder.class);
    private final String _name;
    private final List<Path> _classPath = new ArrayList<Path>();
    private final List<Path> _modulePath = new ArrayList<Path>();
    private final List<String> _jpmsAdds = new ArrayList<String>();
    private final List<String> _jpmsOpens = new ArrayList<String>();
    private final List<String> _jpmsExports = new ArrayList<String>();
    private final List<String> _jpmsReads = new ArrayList<String>();

    public EnvironmentBuilder(@Name(value="name") String name) {
        this._name = name;
    }

    public void addClassPath(String ... classPaths) {
        for (String classPath : classPaths) {
            this._classPath.add(Paths.get(classPath, new String[0]));
        }
    }

    public void addModulePath(String modulePath) {
        this._modulePath.add(Paths.get(modulePath, new String[0]));
    }

    void addModules(String modules) {
        this._jpmsAdds.addAll(List.of(modules.split(",")));
    }

    void patchModule(String patch) {
    }

    void addOpens(String opens) {
        this._jpmsOpens.add(opens);
    }

    void addExports(String exports) {
        this._jpmsExports.add(exports);
    }

    void addReads(String reads) {
        this._jpmsReads.add(reads);
    }

    public Environment build() throws Exception {
        if (this._modulePath.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Building environment {} with class-path {}", (Object)this._name, (Object)this._classPath);
            }
            return Environment.create(this._name, new URLClassLoader(EnvironmentBuilder.toURLs(this._classPath), Environment.class.getClassLoader()));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Building environment {} with module-path {} and class-path {}", this._name, this._modulePath, this._classPath);
        }
        Module parentModule = Environment.class.getModule();
        ModuleLayer parentModuleLayer = parentModule.getLayer();
        ModuleFinder moduleFinder = ModuleFinder.of((Path[])this._modulePath.toArray(Path[]::new));
        Set roots = moduleFinder.findAll().stream().map(moduleReference -> moduleReference.descriptor().name()).collect(Collectors.toCollection(LinkedHashSet::new));
        roots.addAll(this._jpmsAdds);
        Configuration configuration = parentModuleLayer.configuration().resolve(moduleFinder, ModuleFinder.of(new Path[0]), roots);
        ModuleLayer.Controller controller = ModuleLayer.defineModulesWithOneLoader(configuration, List.of(parentModuleLayer), parentModule.getClassLoader());
        this.addOpens(controller, this._jpmsOpens);
        this.addExports(controller, this._jpmsExports);
        this.addReads(controller, this._jpmsReads);
        ClassLoader moduleLayerClassLoader = ((Module)controller.layer().modules().stream().findAny().orElseThrow()).getClassLoader();
        ClassLoader environmentClassLoader = this._classPath.isEmpty() ? moduleLayerClassLoader : new URLClassLoader(EnvironmentBuilder.toURLs(this._classPath), moduleLayerClassLoader);
        return Environment.create(this._name, environmentClassLoader);
    }

    private static URL[] toURLs(List<Path> paths) {
        return (URL[])paths.stream().map(EnvironmentBuilder::toURL).toArray(URL[]::new);
    }

    private static URL toURL(Path path) {
        try {
            return path.toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private void addOpens(ModuleLayer.Controller controller, List<String> opens) {
        for (String open : opens) {
            SourcePackageTargets spt = SourcePackageTargets.from(open);
            Module sourceModule = controller.layer().findModule(spt.sourceModuleName()).orElseThrow();
            spt.targetModuleNames().forEach(targetModuleName -> {
                Module targetModule = controller.layer().findModule((String)targetModuleName).orElse(null);
                if (targetModule != null) {
                    controller.addOpens(sourceModule, spt.packageName(), targetModule);
                }
            });
        }
    }

    private void addExports(ModuleLayer.Controller controller, List<String> exports) {
        for (String export : exports) {
            SourcePackageTargets spt = SourcePackageTargets.from(export);
            Module sourceModule = controller.layer().findModule(spt.sourceModuleName()).orElseThrow();
            spt.targetModuleNames().forEach(targetModuleName -> {
                Module targetModule = controller.layer().findModule((String)targetModuleName).orElse(null);
                if (targetModule != null) {
                    controller.addExports(sourceModule, spt.packageName(), targetModule);
                }
            });
        }
    }

    private void addReads(ModuleLayer.Controller controller, List<String> reads) {
        for (String read : reads) {
            int equal = read.indexOf(61);
            String sourceModuleName = read.substring(0, equal);
            String targetModuleName = read.substring(equal + 1);
            Module sourceModule = controller.layer().findModule(sourceModuleName).orElseThrow();
            Module targetModule = controller.layer().findModule(targetModuleName).orElse(null);
            if (targetModule == null) continue;
            controller.addReads(sourceModule, targetModule);
        }
    }

    private record SourcePackageTargets(String sourceModuleName, String packageName, List<String> targetModuleNames) {
        public static SourcePackageTargets from(String option) {
            int slash = option.indexOf(47);
            String sourceModuleName = option.substring(0, slash);
            int equal = option.indexOf(61, slash + 1);
            String packageName = option.substring(slash + 1, equal);
            List<String> targetModuleNames = List.of(option.substring(equal + 1).split(","));
            return new SourcePackageTargets(sourceModuleName, packageName, targetModuleNames);
        }
    }
}

