/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.util.thread;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import wiremock.org.eclipse.jetty.util.TypeUtil;
import wiremock.org.eclipse.jetty.util.component.Dumpable;
import wiremock.org.eclipse.jetty.util.thread.Invocable;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class SerializedInvoker {
    private static final Logger LOG = LoggerFactory.getLogger(SerializedInvoker.class);
    private final AtomicReference<Link> _tail = new AtomicReference();
    private final String _name;
    private final Executor _executor;
    private volatile Thread _invokerThread;

    public SerializedInvoker() {
        this("anonymous");
    }

    public SerializedInvoker(Class<?> nameFrom) {
        this(nameFrom.getSimpleName());
    }

    public SerializedInvoker(String name) {
        this(name, null);
    }

    public SerializedInvoker(String name, Executor executor) {
        this._name = name;
        this._executor = executor;
    }

    boolean isCurrentThreadInvoking() {
        return this._invokerThread == Thread.currentThread();
    }

    public void assertCurrentThreadInvoking() throws IllegalStateException {
        if (!this.isCurrentThreadInvoking()) {
            throw new IllegalStateException();
        }
    }

    public Runnable offer(Runnable task) {
        Link link;
        Link penultimate;
        boolean queued;
        if (task == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Offering task null, skipping it on {}", (Object)this);
            }
            return null;
        }
        if (NamedRunnable.LOG.isDebugEnabled() && !(task instanceof NamedRunnable)) {
            task = new NamedRunnable(task);
        }
        boolean bl = queued = (penultimate = this._tail.getAndSet(link = new Link(task))) != null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} {} on {}", queued ? "Queued" : "Offered", link, this);
        }
        if (penultimate == null) {
            return link;
        }
        penultimate._next.lazySet(link);
        return null;
    }

    public Runnable offer(Runnable ... tasks) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Offering {} tasks in {}", (Object)tasks.length, (Object)this);
        }
        Runnable runnable = null;
        for (Runnable task : tasks) {
            if (runnable == null) {
                runnable = this.offer(task);
                continue;
            }
            this.offer(task);
        }
        return runnable;
    }

    public void run(Runnable task) {
        Runnable todo = this.offer(task);
        if (todo != null) {
            todo.run();
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Queued link in {}", (Object)this);
        }
    }

    public void run(Runnable ... tasks) {
        Runnable todo = this.offer(tasks);
        if (todo != null) {
            todo.run();
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Queued links in {}", (Object)this);
        }
    }

    public String toString() {
        return String.format("%s@%x{name=%s,tail=%s,invoker=%s}", TypeUtil.toShortName(this.getClass()), this.hashCode(), this._name, this._tail, this._invokerThread);
    }

    protected void onError(Runnable task, Throwable t) {
        LOG.warn("Serialized invocation error", t);
    }

    private class NamedRunnable
    extends Invocable.ReadyTask {
        private static final Logger LOG = LoggerFactory.getLogger(NamedRunnable.class);
        private final String name;
        private final Throwable stack;

        private NamedRunnable(Runnable delegate) {
            super(Invocable.getInvocationType(delegate), delegate);
            this.stack = new Throwable();
            this.name = this.deriveTaskName(delegate, this.stack);
        }

        private String deriveTaskName(Runnable task, Throwable stack) {
            StackTraceElement[] stackTrace;
            for (StackTraceElement stackTraceElement : stackTrace = stack.getStackTrace()) {
                String className = stackTraceElement.getClassName();
                if (className.equals(SerializedInvoker.class.getName()) || className.equals(TypeUtil.toShortName(this.getClass())) || className.equals(this.getClass().getName())) continue;
                return "Queued by " + Thread.currentThread().getName() + " at " + String.valueOf(stackTraceElement);
            }
            return task.toString();
        }

        @Override
        public String toString() {
            return this.name;
        }
    }

    private class Link
    extends Invocable.ReadyTask
    implements Dumpable {
        private final AtomicReference<Link> _next;

        public Link(Runnable task) {
            super(Invocable.getInvocationType(task), task);
            this._next = new AtomicReference();
        }

        @Override
        public void dump(Appendable out, String indent) throws IOException {
            Runnable task = this.getTask();
            if (task instanceof NamedRunnable) {
                NamedRunnable nr = (NamedRunnable)task;
                StringWriter sw = new StringWriter();
                nr.stack.printStackTrace(new PrintWriter(sw));
                Dumpable.dumpObjects(out, indent, nr.toString(), sw.toString());
            } else {
                Dumpable.dumpObjects(out, indent, task, new Object[0]);
            }
            Link link = this._next.get();
            if (link != null) {
                link.dump(out, indent);
            }
        }

        Link next() {
            if (SerializedInvoker.this._tail.compareAndSet(this, null)) {
                return null;
            }
            Link next;
            while ((next = this._next.get()) == null) {
                Thread.onSpinWait();
            }
            return next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Link link = this;
            Invocable.InvocationType firstInvocationType = link.getInvocationType();
            while (link != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Running {} of {}", (Object)link, (Object)SerializedInvoker.this);
                }
                Runnable task = link.getTask();
                Invocable.InvocationType currentInvocationType = link.getInvocationType();
                if (currentInvocationType == Invocable.InvocationType.BLOCKING && firstInvocationType != Invocable.InvocationType.BLOCKING && SerializedInvoker.this._executor != null) {
                    SerializedInvoker.this._executor.execute(link);
                    return;
                }
                SerializedInvoker.this._invokerThread = Thread.currentThread();
                try {
                    task.run();
                }
                catch (Throwable t) {
                    if (LOG.isDebugEnabled()) {
                        LOG.atDebug().setCause(t).log("Failed while running {} of {}", (Object)link, (Object)SerializedInvoker.this);
                    }
                    SerializedInvoker.this.onError(task, t);
                }
                finally {
                    SerializedInvoker.this._invokerThread = null;
                }
                if ((link = link.next()) != null || !LOG.isDebugEnabled()) continue;
                LOG.debug("Next link is null, execution is over in {}", (Object)SerializedInvoker.this);
            }
        }

        @Override
        public String toString() {
            return String.format("%s@%x{%s[%s] -> %s}", new Object[]{TypeUtil.toShortName(this.getClass()), this.hashCode(), this.getTask(), this.getInvocationType(), this._next});
        }
    }
}

