/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.util.security;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionException;
import javax.security.auth.Subject;

public class SecurityUtils {
    private static final MethodHandle callAs = SecurityUtils.lookupCallAs();
    private static final MethodHandle doPrivileged = SecurityUtils.lookupDoPrivileged();
    private static final MethodHandle getSecurityManager = SecurityUtils.lookupGetSecurityManager();
    private static final MethodHandle checkPermission = SecurityUtils.lookupCheckPermission();

    private static MethodHandle lookupCallAs() {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            return lookup.findStatic(Subject.class, "callAs", MethodType.methodType(Object.class, Subject.class, Callable.class));
        }
        catch (Throwable x) {
            try {
                MethodType oldSignature = MethodType.methodType(Object.class, Subject.class, PrivilegedAction.class);
                MethodHandle doAs = lookup.findStatic(Subject.class, "doAs", oldSignature);
                MethodType convertSignature = MethodType.methodType(PrivilegedAction.class, Callable.class);
                MethodHandle converter = lookup.findStatic(SecurityUtils.class, "callableToPrivilegedAction", convertSignature);
                return MethodHandles.filterArguments(doAs, 1, converter);
            }
            catch (Throwable t) {
                return null;
            }
        }
    }

    private static MethodHandle lookupDoPrivileged() {
        try {
            Class<?> klass = ClassLoader.getPlatformClassLoader().loadClass("java.security.AccessController");
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            return lookup.findStatic(klass, "doPrivileged", MethodType.methodType(Object.class, PrivilegedAction.class));
        }
        catch (Throwable x) {
            return null;
        }
    }

    private static MethodHandle lookupGetSecurityManager() {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            return lookup.findStatic(System.class, "getSecurityManager", MethodType.methodType(Object.class));
        }
        catch (Throwable x) {
            return null;
        }
    }

    private static MethodHandle lookupCheckPermission() {
        try {
            Class<?> klass = ClassLoader.getPlatformClassLoader().loadClass("java.lang.SecurityManager");
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            return lookup.findVirtual(klass, "checkPermission", MethodType.methodType(Void.class, Permission.class));
        }
        catch (Throwable x) {
            return null;
        }
    }

    public static Object getSecurityManager() {
        if (getSecurityManager == null) {
            return null;
        }
        try {
            return getSecurityManager.invoke();
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    public static void checkPermission(Permission permission) throws SecurityException {
        if (getSecurityManager == null || checkPermission == null) {
            return;
        }
        Object securityManager = SecurityUtils.getSecurityManager();
        if (securityManager == null) {
            return;
        }
        try {
            checkPermission.invoke(securityManager, permission);
        }
        catch (NullPointerException | SecurityException x) {
            throw x;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static <T> T doPrivileged(PrivilegedAction<T> action) {
        if (doPrivileged == null) {
            return action.run();
        }
        return SecurityUtils.doPrivileged(doPrivileged, action);
    }

    private static <T> T doPrivileged(MethodHandle doPrivileged, PrivilegedAction<T> action) {
        try {
            return (T)doPrivileged.invoke(action);
        }
        catch (Error | RuntimeException x) {
            throw x;
        }
        catch (Throwable x) {
            throw new RuntimeException(x);
        }
    }

    @Deprecated(forRemoval=true, since="12.1.0")
    public static <T> T doAs(Subject subject, Callable<T> action) {
        return SecurityUtils.callAs(subject, action);
    }

    public static <T> T callAs(Subject subject, Callable<T> action) {
        try {
            if (callAs == null) {
                return action.call();
            }
            return (T)callAs.invoke(subject, action);
        }
        catch (Error | RuntimeException x) {
            throw x;
        }
        catch (Throwable x) {
            throw new CompletionException(x);
        }
    }

    private static <T> PrivilegedAction<T> callableToPrivilegedAction(Callable<T> callable) {
        return () -> {
            try {
                return callable.call();
            }
            catch (RuntimeException x) {
                throw x;
            }
            catch (Exception x) {
                throw new RuntimeException(x);
            }
        };
    }

    private SecurityUtils() {
    }
}

