/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.util.component;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import wiremock.org.eclipse.jetty.util.TypeUtil;
import wiremock.org.eclipse.jetty.util.component.Dumpable;

public class DumpableCollection
implements Dumpable {
    private final String _name;
    private final Collection<?> _collection;

    public DumpableCollection(String name, Collection<?> collection) {
        this._name = name;
        this._collection = Objects.requireNonNullElseGet(collection, Collections::emptyList);
    }

    public static DumpableCollection fromArray(String name, Object[] array) {
        return new DumpableCollection(name, array == null ? Collections.emptyList() : Arrays.asList(array));
    }

    public static DumpableCollection from(String name, Object ... items) {
        return new DumpableCollection(name, items == null ? Collections.emptyList() : Arrays.asList(items));
    }

    public static DumpableCollection from(String name, Collection<?> collection) {
        return new DumpableCollection(name, collection);
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        Object[] array = this._collection.toArray();
        Dumpable.dumpObjects(out, indent, this, array);
    }

    @Override
    public String dumpSelf() {
        return this._name + " size=" + this._collection.size();
    }

    public String toString() {
        return "%s@%x[%s,size=%d]".formatted(TypeUtil.toShortName(this.getClass()), this.hashCode(), this._name, this._collection.size());
    }
}

