/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.util;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import wiremock.org.eclipse.jetty.util.QuotedStringTokenizer;
import wiremock.org.eclipse.jetty.util.TypeUtil;

public class RFC9110QuotedStringTokenizer
implements QuotedStringTokenizer {
    private final String _delim;
    private final boolean _optionalWhiteSpace;
    private final boolean _returnDelimiters;
    private final boolean _returnQuotes;
    private final boolean _embeddedQuotes;
    private final boolean _escapeOnlyQuote;

    RFC9110QuotedStringTokenizer(String delim, boolean optionalWhiteSpace, boolean returnDelimiters, boolean returnQuotes, boolean embeddedQuotes, boolean escapeOnlyQuote) {
        this._delim = Objects.requireNonNull(delim);
        this._optionalWhiteSpace = optionalWhiteSpace;
        this._returnDelimiters = returnDelimiters;
        this._returnQuotes = returnQuotes;
        this._embeddedQuotes = embeddedQuotes;
        this._escapeOnlyQuote = escapeOnlyQuote;
        if (this._delim.indexOf(34) >= 0) {
            throw new IllegalArgumentException("Can't use quote as delimiters: " + this._delim);
        }
        if (this._optionalWhiteSpace && this._delim.indexOf(32) >= 0) {
            throw new IllegalArgumentException("Can't delimit with space with optional white space");
        }
    }

    protected boolean isOptionalWhiteSpace(char c) {
        return Character.isWhitespace(c);
    }

    @Override
    public Iterator<String> tokenize(final String string) {
        Objects.requireNonNull(string);
        return new Iterator<String>(this){
            private final StringBuilder _token = new StringBuilder();
            State _state = State.START;
            private boolean _hasToken;
            private int _ows = -1;
            private int _i = 0;
            final /* synthetic */ RFC9110QuotedStringTokenizer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean hasNext() {
                if (this._hasToken) {
                    return true;
                }
                boolean escape = false;
                block6: while (this._i < string.length()) {
                    char c = string.charAt(this._i++);
                    switch (this._state.ordinal()) {
                        case 0: {
                            if (this.this$0._delim.indexOf(c) >= 0) {
                                if (!this.this$0._returnDelimiters) continue block6;
                                this._token.append(c);
                                this._hasToken = true;
                                return true;
                            }
                            if (c == '\"') {
                                if (this.this$0._returnQuotes) {
                                    this._token.append(c);
                                }
                                this._ows = -1;
                                this._state = State.QUOTE;
                                continue block6;
                            }
                            if (this.this$0._optionalWhiteSpace && this.this$0.isOptionalWhiteSpace(c)) continue block6;
                            this._token.append(c);
                            this._hasToken = true;
                            this._ows = -1;
                            this._state = State.TOKEN;
                            continue block6;
                        }
                        case 1: {
                            this._hasToken = true;
                            if (this.this$0._delim.indexOf(c) >= 0) {
                                if (this.this$0._returnDelimiters) {
                                    --this._i;
                                }
                                this._state = State.START;
                                if (this._ows >= 0) {
                                    this._token.setLength(this._ows);
                                }
                                return this._hasToken;
                            }
                            if (this.this$0._embeddedQuotes && c == '\"') {
                                if (this.this$0._returnQuotes) {
                                    this._token.append(c);
                                }
                                this._ows = -1;
                                this._state = State.QUOTE;
                                continue block6;
                            }
                            if (this.this$0._optionalWhiteSpace && this.this$0.isOptionalWhiteSpace(c)) {
                                if (this._ows < 0) {
                                    this._ows = this._token.length();
                                }
                                this._token.append(c);
                                continue block6;
                            }
                            this._ows = -1;
                            this._token.append(c);
                            continue block6;
                        }
                        case 2: {
                            this._hasToken = true;
                            if (escape) {
                                escape = false;
                                this._token.append(c);
                                continue block6;
                            }
                            if (c == '\"') {
                                if (this.this$0._returnQuotes) {
                                    this._token.append(c);
                                }
                                if (this.this$0._embeddedQuotes) {
                                    this._ows = -1;
                                    this._state = State.TOKEN;
                                    continue block6;
                                }
                                this._state = State.END;
                                return this._hasToken;
                            }
                            if (c == '\\') {
                                if (this.this$0._escapeOnlyQuote && (this._i >= string.length() || string.charAt(this._i) != '\"')) {
                                    this._token.append(c);
                                    continue block6;
                                }
                                if (this.this$0._returnQuotes) {
                                    this._token.append(c);
                                }
                                escape = true;
                                continue block6;
                            }
                            this._token.append(c);
                            continue block6;
                        }
                        case 3: {
                            if (this.this$0._delim.indexOf(c) >= 0) {
                                this._state = State.START;
                                if (!this.this$0._returnDelimiters) continue block6;
                                this._token.append(c);
                                this._hasToken = true;
                                return true;
                            }
                            if (this.this$0._optionalWhiteSpace && this.this$0.isOptionalWhiteSpace(c)) continue block6;
                            throw new IllegalArgumentException("characters after end quote");
                        }
                    }
                    throw new IllegalStateException();
                }
                if (this._state == State.QUOTE) {
                    throw new IllegalArgumentException("unterminated quote");
                }
                if (this._ows >= 0 && this._hasToken) {
                    this._token.setLength(this._ows);
                }
                return this._hasToken;
            }

            @Override
            public String next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                String t = this._token.toString();
                this._token.setLength(0);
                this._hasToken = false;
                return t;
            }

            private static enum State {
                START,
                TOKEN,
                QUOTE,
                END;

            }
        };
    }

    @Override
    public void quote(Appendable buffer, String input) {
        if (input == null) {
            return;
        }
        try {
            buffer.append('\"');
            for (int i = 0; i < input.length(); ++i) {
                char c = input.charAt(i);
                if (c == '\"' || c == '\\') {
                    buffer.append('\\').append(c);
                    continue;
                }
                buffer.append(c);
            }
            buffer.append('\"');
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    @Override
    public String quoteIfNeeded(String s) {
        return this.quoteIfNeededImpl(null, s);
    }

    @Override
    public void quoteIfNeeded(StringBuilder buf, String str) {
        this.quoteIfNeededImpl(buf, str);
    }

    @Override
    public boolean needsQuoting(char c) {
        return c == '\\' || c == '\"' || this._optionalWhiteSpace && Character.isWhitespace(c) || this._delim.indexOf(c) >= 0;
    }

    private String quoteIfNeededImpl(StringBuilder buf, String str) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            if (buf == null) {
                return "\"\"";
            }
            buf.append("\"\"");
            return null;
        }
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (!this.needsQuoting(c)) continue;
            if (buf == null) {
                return this.quote(str);
            }
            this.quote(buf, str);
            return null;
        }
        if (buf == null) {
            return str;
        }
        buf.append(str);
        return null;
    }

    @Override
    public String unquote(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() < 2) {
            return s;
        }
        char first = s.charAt(0);
        char last = s.charAt(s.length() - 1);
        if (first != '\"' || last != '\"') {
            return s;
        }
        StringBuilder b = new StringBuilder(s.length() - 2);
        boolean escape = false;
        for (int i = 1; i < s.length() - 1; ++i) {
            char c = s.charAt(i);
            if (escape) {
                escape = false;
                b.append(c);
                continue;
            }
            if (c == '\\') {
                escape = true;
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append(TypeUtil.toShortName(this.getClass())).append('@').append(Long.toHexString(this.hashCode())).append("{'").append(this._delim).append('\'');
        if (this._optionalWhiteSpace) {
            out.append(",optionalWhiteSpace");
        }
        if (this._returnDelimiters) {
            out.append(",returnDelimiters");
        }
        if (this._returnQuotes) {
            out.append(",returnQuotes");
        }
        if (this._embeddedQuotes) {
            out.append(",embeddedQuotes");
        }
        if (this._escapeOnlyQuote) {
            out.append(",escapeOnlyQuote");
        }
        out.append('}');
        return out.toString();
    }
}

