/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import wiremock.org.eclipse.jetty.http.pathmap.MappedResource;
import wiremock.org.eclipse.jetty.http.pathmap.MatchedPath;
import wiremock.org.eclipse.jetty.http.pathmap.MatchedResource;
import wiremock.org.eclipse.jetty.http.pathmap.PathMappings;
import wiremock.org.eclipse.jetty.http.pathmap.PathSpec;
import wiremock.org.eclipse.jetty.http.pathmap.ServletPathSpec;
import wiremock.org.eclipse.jetty.server.Context;
import wiremock.org.eclipse.jetty.server.Handler;
import wiremock.org.eclipse.jetty.server.Request;
import wiremock.org.eclipse.jetty.server.Response;
import wiremock.org.eclipse.jetty.server.Server;
import wiremock.org.eclipse.jetty.util.Callback;
import wiremock.org.eclipse.jetty.util.StringUtil;
import wiremock.org.eclipse.jetty.util.component.Dumpable;
import wiremock.org.eclipse.jetty.util.thread.Invocable;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class PathMappingsHandler
extends Handler.AbstractContainer {
    private static final Logger LOG = LoggerFactory.getLogger(PathMappingsHandler.class);
    public static final String PATHSPEC_ATTR = PathMappingsHandler.class.getName() + ".pathSpec";
    private final PathMappings<Handler> mappings = new PathMappings();

    public PathMappingsHandler() {
        this(true);
    }

    public PathMappingsHandler(boolean dynamic) {
        super(dynamic);
    }

    @Override
    public List<Handler> getHandlers() {
        return this.mappings.streamResources().map(MappedResource::getResource).toList();
    }

    public void addMapping(PathSpec pathSpec, Handler handler) {
        Handler.Container container;
        Objects.requireNonNull(pathSpec, "PathSpec cannot be null");
        Objects.requireNonNull(handler, "Handler cannot be null");
        if (!this.isDynamic() && this.isStarted()) {
            throw new IllegalStateException("Cannot add mapping: " + String.valueOf(this));
        }
        if (handler == this) {
            throw new IllegalStateException("Unable to addHandler of self: " + String.valueOf(handler));
        }
        if (handler instanceof Handler.Container && (container = (Handler.Container)handler).getDescendants().contains(this)) {
            throw new IllegalStateException("loop detected: " + String.valueOf(handler));
        }
        Server server = this.getServer();
        if (server != null) {
            handler.setServer(server);
            Invocable.InvocationType serverInvocationType = server.getInvocationType();
            Invocable.InvocationType invocationType = Invocable.InvocationType.NON_BLOCKING;
            invocationType = Invocable.combine(invocationType, handler.getInvocationType());
            if (this.isDynamic() && server.isStarted() && serverInvocationType != invocationType && serverInvocationType != Invocable.InvocationType.BLOCKING) {
                throw new IllegalArgumentException("Cannot change invocation type of started server");
            }
        }
        Handler old = this.mappings.get(pathSpec);
        this.mappings.put(pathSpec, handler);
        this.updateBean(old, handler);
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        Dumpable.dumpObjects(out, indent, this, this.mappings);
    }

    @Override
    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        String pathInContext = Request.getPathInContext(request);
        MatchedResource<Handler> matchedResource = this.mappings.getMatched(pathInContext);
        if (matchedResource == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No mappings matched {}", (Object)pathInContext);
            }
            return false;
        }
        Handler handler = matchedResource.getResource();
        PathSpec pathSpec = matchedResource.getPathSpec();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Matched {} to {} -> {}", pathInContext, matchedResource.getPathSpec(), handler);
        }
        Request pathSpecRequest = this.newPathSpecRequest(request, pathSpec);
        boolean handled = handler.handle(pathSpecRequest, response, callback);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Handled {} {} by {}", handled, pathInContext, handler);
        }
        return handled;
    }

    protected Request newPathSpecRequest(Request request, PathSpec pathSpec) {
        return new PathSpecRequest(request, pathSpec);
    }

    public static class PathSpecRequest
    extends Request.Wrapper {
        private final PathSpec pathSpec;
        private final Context context;
        private final MatchedPath matchedPath;

        public PathSpecRequest(Request request, final PathSpec pathSpec) {
            super(request);
            this.pathSpec = pathSpec;
            this.matchedPath = pathSpec.matched(request.getHttpURI().getCanonicalPath());
            this.setAttribute(PathSpec.class.getName(), this.pathSpec);
            this.context = new Context.Wrapper(this, request.getContext()){
                final /* synthetic */ PathSpecRequest this$0;
                {
                    this.this$0 = this$0;
                    super(context);
                }

                @Override
                public String getContextPath() {
                    String contextPath = this.this$0.getWrapped().getContext().getContextPath();
                    if (pathSpec instanceof ServletPathSpec) {
                        ServletPathSpec servletPathSpec = (ServletPathSpec)pathSpec;
                        return this.appendContextPath(contextPath, servletPathSpec.getPrefix());
                    }
                    return this.appendContextPath(contextPath, this.this$0.matchedPath.getPathMatch());
                }

                private String appendContextPath(String contextPath1, String contextPath2) {
                    if (StringUtil.isBlank(contextPath2)) {
                        return contextPath1;
                    }
                    if (contextPath2.charAt(0) != '/') {
                        if (contextPath1.endsWith("/")) {
                            return contextPath1 + contextPath2;
                        }
                        return contextPath1 + "/" + contextPath2;
                    }
                    if (contextPath1.equals("/")) {
                        return contextPath2;
                    }
                    if (contextPath1.endsWith("/")) {
                        return contextPath1.substring(contextPath1.length() - 1) + contextPath2;
                    }
                    return contextPath1 + contextPath2;
                }

                @Override
                public String getPathInContext(String canonicallyEncodedPath) {
                    if (pathSpec instanceof ServletPathSpec) {
                        return Context.getPathInContext(this.getContextPath(), canonicallyEncodedPath);
                    }
                    String pathInfo = this.this$0.matchedPath.getPathInfo();
                    return pathInfo == null ? "" : pathInfo;
                }
            };
        }

        @Override
        public Object getAttribute(String name) {
            if (name.equals(PATHSPEC_ATTR)) {
                return this.pathSpec;
            }
            return super.getAttribute(name);
        }

        @Override
        public Set<String> getAttributeNameSet() {
            HashSet<String> names = new HashSet<String>(super.getAttributeNameSet());
            names.add(PATHSPEC_ATTR);
            return names;
        }

        @Override
        public Context getContext() {
            return this.context;
        }
    }

    public static class NoContext
    extends PathMappingsHandler {
        @Override
        protected Request newPathSpecRequest(Request request, PathSpec pathSpec) {
            return request;
        }
    }
}

