/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.server.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import wiremock.org.eclipse.jetty.server.Handler;
import wiremock.org.eclipse.jetty.server.Request;
import wiremock.org.eclipse.jetty.server.Response;
import wiremock.org.eclipse.jetty.server.handler.ContextHandler;
import wiremock.org.eclipse.jetty.util.ArrayUtil;
import wiremock.org.eclipse.jetty.util.Callback;
import wiremock.org.eclipse.jetty.util.Index;
import wiremock.org.eclipse.jetty.util.annotation.ManagedAttribute;
import wiremock.org.eclipse.jetty.util.annotation.ManagedObject;
import wiremock.org.eclipse.jetty.util.annotation.ManagedOperation;
import wiremock.org.eclipse.jetty.util.thread.SerializedExecutor;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

@ManagedObject(value="Context Handler Collection")
public class ContextHandlerCollection
extends Handler.Sequence {
    private static final Logger LOG = LoggerFactory.getLogger(ContextHandlerCollection.class);
    private final SerializedExecutor _serializedExecutor = new SerializedExecutor();

    public ContextHandlerCollection(ContextHandler ... contexts) {
        this(true, contexts);
    }

    public ContextHandlerCollection(boolean dynamic, ContextHandler ... contexts) {
        super(dynamic, List.of(contexts));
    }

    @ManagedOperation(value="Update the mapping of context path to context", impact="ACTION")
    public void mapContexts() {
        this._serializedExecutor.execute(() -> {
            List<Handler> handlers = this.getHandlers();
            if (handlers == null) {
                return;
            }
            super.setHandlers(this.newHandlers(handlers));
        });
    }

    @Override
    protected List<Handler> newHandlers(List<Handler> handlers) {
        if (handlers == null || handlers.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<String, Branch[]> path2Branches = new HashMap<String, Branch[]>();
        for (Handler handler : handlers) {
            Branch branch = new Branch(handler);
            for (String contextPath : branch.getContextPaths()) {
                path2Branches.compute(contextPath, (k, branches) -> ArrayUtil.addToArray(branches, branch, Branch.class));
            }
        }
        for (Map.Entry entry : path2Branches.entrySet()) {
            Branch[] branches2 = (Branch[])entry.getValue();
            Branch[] sorted = new Branch[branches2.length];
            int i = 0;
            for (Branch branch : branches2) {
                if (!branch.hasVirtualHost()) continue;
                sorted[i++] = branch;
            }
            for (Branch branch : branches2) {
                if (branch.hasVirtualHost()) continue;
                sorted[i++] = branch;
            }
            entry.setValue(sorted);
        }
        Mapping mapping = new Mapping(handlers, path2Branches);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}", (Object)mapping._pathBranches);
        }
        return mapping;
    }

    @Override
    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        Map.Entry<String, Branch[]> branches;
        List<Handler> handlers = this.getHandlers();
        if (handlers == null || handlers.isEmpty()) {
            return false;
        }
        if (!(handlers instanceof Mapping)) {
            return super.handle(request, response, callback);
        }
        Mapping mapping = (Mapping)this.getHandlers();
        if (handlers.size() == 1) {
            return handlers.get(0).handle(request, response, callback);
        }
        Index<Map.Entry<String, Branch[]>> pathBranches = mapping._pathBranches;
        if (pathBranches == null) {
            return false;
        }
        String path = Request.getPathInContext(request);
        if (!path.startsWith("/")) {
            return super.handle(request, response, callback);
        }
        int limit = path.length() - 1;
        while (limit >= 0 && (branches = pathBranches.getBest(path, 1, limit)) != null) {
            int l = branches.getKey().length();
            if (l == 1 || path.length() == l || path.charAt(l) == '/') {
                for (Branch branch : branches.getValue()) {
                    try {
                        if (branch.getHandler().handle(request, response, callback)) {
                            return true;
                        }
                    }
                    catch (Throwable t) {
                        LOG.warn("Unaccepted error {}", (Object)this, (Object)t);
                    }
                }
            }
            limit = l - 2;
        }
        return false;
    }

    @ManagedAttribute(value="The paths of the contexts in this collection")
    public Set<String> getContextPaths() {
        List<Handler> handlers = this.getHandlers();
        if (handlers instanceof Mapping) {
            Mapping mapping = (Mapping)handlers;
            Index<Map.Entry<String, Branch[]>> index = mapping._pathBranches;
            return index.keySet().stream().map(index::get).map(Map.Entry::getValue).flatMap(Stream::of).flatMap(b -> b.getContextPaths().stream()).collect(Collectors.toCollection(TreeSet::new));
        }
        return Set.of();
    }

    public void deployHandler(final Handler handler, final Callback callback) {
        this._serializedExecutor.execute((Runnable)new SerializedExecutor.ErrorHandlingTask(){
            final /* synthetic */ ContextHandlerCollection this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.addHandler(handler);
                callback.succeeded();
            }

            @Override
            public void accept(Throwable throwable) {
                callback.failed(throwable);
            }
        });
    }

    public void redeployHandler(final Handler oldHandler, final Handler newHandler, final Callback callback) {
        this._serializedExecutor.execute((Runnable)new SerializedExecutor.ErrorHandlingTask(){
            final /* synthetic */ ContextHandlerCollection this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if (this.this$0.replaceHandler(oldHandler, newHandler)) {
                    this.this$0.stopHandler(oldHandler);
                    callback.succeeded();
                } else {
                    callback.failed(new IllegalStateException("No such handler: " + String.valueOf(oldHandler)));
                }
            }

            @Override
            public void accept(Throwable throwable) {
                callback.failed(throwable);
            }
        });
    }

    public void undeployHandler(final Handler handler, final Callback callback) {
        this._serializedExecutor.execute((Runnable)new SerializedExecutor.ErrorHandlingTask(){
            final /* synthetic */ ContextHandlerCollection this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.removeHandler(handler);
                this.this$0.stopHandler(handler);
                callback.succeeded();
            }

            @Override
            public void accept(Throwable throwable) {
                callback.failed(throwable);
            }
        });
    }

    private void stopHandler(Handler contextHandler) {
        if (contextHandler == null) {
            return;
        }
        try {
            contextHandler.stop();
        }
        catch (Exception e) {
            LOG.warn("Unable to stop {}", (Object)contextHandler, (Object)e);
        }
    }

    private static final class Branch {
        private final Handler _handler;
        private final List<ContextHandler> _contexts;

        Branch(Handler handler) {
            this._handler = handler;
            if (handler instanceof ContextHandler) {
                this._contexts = List.of((ContextHandler)handler);
            } else if (handler instanceof Handler.Container) {
                List<ContextHandler> contexts = ((Handler.Container)handler).getDescendants(ContextHandler.class);
                this._contexts = new ArrayList<ContextHandler>(contexts);
            } else {
                this._contexts = List.of();
            }
        }

        Set<String> getContextPaths() {
            HashSet<String> set = new HashSet<String>();
            for (ContextHandler context : this._contexts) {
                set.add(context.getContextPath());
            }
            return set;
        }

        boolean hasVirtualHost() {
            for (ContextHandler context : this._contexts) {
                if (context.getVirtualHosts() == null || context.getVirtualHosts().size() <= 0) continue;
                return true;
            }
            return false;
        }

        Handler getHandler() {
            return this._handler;
        }

        public String toString() {
            return String.format("{%s,%s}", this._handler, this._contexts);
        }
    }

    private static class Mapping
    extends ArrayList<Handler> {
        private final Index<Map.Entry<String, Branch[]>> _pathBranches = new Index.Builder().caseSensitive(true).withAll(() -> {
            LinkedHashMap result = new LinkedHashMap();
            for (Map.Entry entry : path2Branches.entrySet()) {
                result.put(((String)entry.getKey()).substring(1), entry);
            }
            return result;
        }).build();

        private Mapping(List<Handler> handlers, Map<String, Branch[]> path2Branches) {
            super(handlers);
        }
    }
}

