/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.server;

import java.net.ServerSocket;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import wiremock.org.eclipse.jetty.server.ShutdownService;
import wiremock.org.eclipse.jetty.util.StringUtil;
import wiremock.org.eclipse.jetty.util.component.LifeCycle;
import wiremock.org.eclipse.jetty.util.thread.AutoLock;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

@Deprecated(since="12.1.0", forRemoval=true)
public class ShutdownMonitor
extends ShutdownService {
    private static final Logger LOG = LoggerFactory.getLogger(ShutdownMonitor.class);
    private static final AtomicReference<ShutdownMonitor> INSTANCE = new AtomicReference();
    private int mutablePort = Integer.parseInt(ShutdownMonitor.getSysProp("STOP.PORT", "-1"));
    private String mutableKey = super.getKey();
    private boolean mutableExitVm = super.isExitVm();

    @Deprecated(since="12.1.0", forRemoval=true)
    public static ShutdownMonitor getInstance() {
        return INSTANCE.updateAndGet(h -> {
            if (h != null) {
                return h;
            }
            LOG.warn("{} is deprecated, and has been replaced with {}", (Object)ShutdownMonitor.class.getName(), (Object)ShutdownService.class.getName());
            return new ShutdownMonitor();
        });
    }

    protected static ShutdownMonitor getConfiguredInstance() {
        return INSTANCE.updateAndGet(h -> {
            if (h != null) {
                return h;
            }
            if (System.getProperty("STOP.PORT") != null) {
                LOG.warn("{} is deprecated, and has been replaced with {}", (Object)ShutdownMonitor.class.getName(), (Object)ShutdownService.class.getName());
                try {
                    return new ShutdownMonitor();
                }
                catch (Throwable x) {
                    LOG.warn("Unable to create ShutdownMonitor", x);
                }
            }
            return null;
        });
    }

    @Deprecated(since="12.1.0", forRemoval=true)
    protected static void reset() {
        INSTANCE.set(null);
    }

    @Deprecated(since="12.1.0", forRemoval=true)
    public static void register(LifeCycle ... lifeCycles) {
        ShutdownMonitor.getInstance().addLifeCycles(lifeCycles);
    }

    @Deprecated(since="12.1.0", forRemoval=true)
    public static void deregister(LifeCycle lifeCycle) {
        ShutdownMonitor.getInstance().removeLifeCycle(lifeCycle);
    }

    @Deprecated(since="12.1.0", forRemoval=true)
    public static boolean isRegistered(LifeCycle lifeCycle) {
        return ShutdownMonitor.getInstance().containsLifeCycle(lifeCycle);
    }

    private ShutdownMonitor() {
        super(ShutdownMonitor.getSysProp("STOP.HOST", "127.0.0.1"), Integer.parseInt(ShutdownMonitor.getSysProp("STOP.PORT", "0")), ShutdownMonitor.getSysProp("STOP.KEY", null), Boolean.parseBoolean(ShutdownMonitor.getSysProp("STOP.EXIT", "true")));
    }

    private static String getSysProp(String keyName, String defaultValue) {
        String value = System.getProperty(keyName, defaultValue);
        if (StringUtil.isBlank(value)) {
            return defaultValue;
        }
        return value;
    }

    private void addLifeCycles(LifeCycle ... lifeCycles) {
        try (AutoLock l = this.lock.lock();){
            for (LifeCycle lifeCycle : lifeCycles) {
                this.addComponent(lifeCycle);
            }
        }
    }

    private void removeLifeCycle(LifeCycle lifeCycle) {
        this.removeComponent(lifeCycle);
    }

    private boolean containsLifeCycle(LifeCycle lifeCycle) {
        return this.hasComponent(lifeCycle);
    }

    public boolean isConfigured() {
        return this.mutablePort >= 0 && this.mutablePort <= 65535;
    }

    @Deprecated(since="12.1.0", forRemoval=true)
    public void setDebug(boolean flag) {
    }

    @Deprecated(since="12.1.0", forRemoval=true)
    public void setExitVm(boolean exitVm) {
        this.mutableExitVm = exitVm;
    }

    @Override
    public boolean isExitVm() {
        return this.mutableExitVm;
    }

    @Override
    public int getPort() {
        return this.mutablePort;
    }

    @Deprecated(since="12.1.0", forRemoval=true)
    public void setPort(int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid port: " + port);
        }
        this.mutablePort = port;
    }

    @Deprecated(since="12.1.0", forRemoval=true)
    public void setKey(String key) {
        this.mutableKey = key;
    }

    @Override
    public String getKey() {
        return this.mutableKey;
    }

    @Override
    public void start() throws Exception {
        int port = this.getPort();
        if (port < 0 || port > 65535) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Not enabling ShutdownMonitor, port not configured");
            }
            return;
        }
        super.start();
    }

    @Override
    protected void bound(ServerSocket serverSocket) {
        if (serverSocket == null) {
            return;
        }
        if (!serverSocket.isBound()) {
            return;
        }
        this.mutablePort = serverSocket.getLocalPort();
    }

    @Deprecated(since="12.1.0", forRemoval=true)
    public void await() throws InterruptedException {
        throw new UnsupportedOperationException("await() no longer supported");
    }

    @Deprecated(since="12.1.0", forRemoval=true)
    protected boolean await(long time, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException("await(long, TimeUnit) no longer supported");
    }

    protected boolean isAlive() {
        return this.isListening();
    }
}

