/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.server;

import java.nio.channels.SelectableChannel;
import java.util.ArrayList;
import java.util.List;
import wiremock.org.eclipse.jetty.io.EndPoint;
import wiremock.org.eclipse.jetty.io.SelectorManager;
import wiremock.org.eclipse.jetty.server.AbstractConnector;
import wiremock.org.eclipse.jetty.server.Connector;
import wiremock.org.eclipse.jetty.server.Server;
import wiremock.org.eclipse.jetty.util.IO;
import wiremock.org.eclipse.jetty.util.annotation.ManagedAttribute;
import wiremock.org.eclipse.jetty.util.annotation.Name;
import wiremock.org.eclipse.jetty.util.component.AbstractLifeCycle;
import wiremock.org.eclipse.jetty.util.thread.AutoLock;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class NetworkConnectionLimit
extends AbstractLifeCycle
implements SelectorManager.AcceptListener {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkConnectionLimit.class);
    private final AutoLock _lock = new AutoLock();
    private final Server _server;
    private final List<AbstractConnector> _connectors = new ArrayList<AbstractConnector>();
    private int _pendingConnections;
    private int _connections;
    private int _maxNetworkConnections;
    private long _endPointIdleTimeout;
    private boolean _limiting;

    public NetworkConnectionLimit(@Name(value="maxNetworkConnectionCount") int maxNetworkConnections, @Name(value="server") Server server) {
        this._maxNetworkConnections = maxNetworkConnections;
        this._server = server;
    }

    public NetworkConnectionLimit(@Name(value="maxNetworkConnectionCount") int maxNetworkConnections, Connector ... connectors) {
        this(maxNetworkConnections, (Server)null);
        this.registerConnectors(connectors);
    }

    private void registerConnectors(Connector[] connectors) {
        for (Connector c : connectors) {
            if (c instanceof AbstractConnector) {
                this._connectors.add((AbstractConnector)c);
                continue;
            }
            LOG.warn("Connector {} is not an instance of {}: network connections will not be limited", (Object)c, (Object)AbstractConnector.class.getSimpleName());
        }
    }

    @ManagedAttribute(value="The EndPoint idle timeout in ms to apply when the network connection limit is reached")
    public long getEndPointIdleTimeout() {
        return this._endPointIdleTimeout;
    }

    public void setEndPointIdleTimeout(long idleTimeout) {
        this._endPointIdleTimeout = idleTimeout;
    }

    @ManagedAttribute(value="The maximum number of network connections")
    public int getMaxNetworkConnectionCount() {
        try (AutoLock ignored = this._lock.lock();){
            int n = this._maxNetworkConnections;
            return n;
        }
    }

    public void setMaxNetworkConnectionCount(int max) {
        try (AutoLock ignored = this._lock.lock();){
            this._maxNetworkConnections = max;
        }
    }

    @ManagedAttribute(value="The number of connected network connections")
    public int getNetworkConnectionCount() {
        try (AutoLock ignored = this._lock.lock();){
            int n = this._connections;
            return n;
        }
    }

    @ManagedAttribute(value="The number of pending network connections")
    public int getPendingNetworkConnectionCount() {
        try (AutoLock ignored = this._lock.lock();){
            int n = this._pendingConnections;
            return n;
        }
    }

    @Override
    protected void doStart() throws Exception {
        try (AutoLock ignored = this._lock.lock();){
            if (this._server != null) {
                this.registerConnectors(this._server.getConnectors());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Network connection limit {} for {}", (Object)this._maxNetworkConnections, (Object)this._connectors);
            }
            this._connections = 0;
            this._limiting = false;
            for (AbstractConnector c : this._connectors) {
                c.addBean(this);
            }
        }
    }

    @Override
    protected void doStop() throws Exception {
        try (AutoLock ignored = this._lock.lock();){
            for (AbstractConnector c : this._connectors) {
                c.removeBean(this);
            }
            this._connections = 0;
            if (this._server != null) {
                this._connectors.clear();
            }
        }
    }

    private boolean lockedCheck() {
        assert (this._lock.isHeldByCurrentThread());
        int total = this._pendingConnections + this._connections;
        if (total >= this._maxNetworkConnections) {
            if (!this._limiting) {
                this._limiting = true;
                LOG.info("Network connection limit {} reached for {}", (Object)this._maxNetworkConnections, (Object)this._connectors);
                this.limit();
            }
            return total > this._maxNetworkConnections;
        }
        if (this._limiting) {
            this._limiting = false;
            LOG.info("Network connection limit {} cleared for {}", (Object)this._maxNetworkConnections, (Object)this._connectors);
            this.unlimit();
        }
        return false;
    }

    protected void limit() {
        assert (this._lock.isHeldByCurrentThread());
        for (AbstractConnector c : this._connectors) {
            c.setAccepting(false);
            if (this._endPointIdleTimeout <= 0L) continue;
            for (EndPoint endPoint : c.getConnectedEndPoints()) {
                endPoint.setIdleTimeout(this._endPointIdleTimeout);
            }
        }
    }

    protected void unlimit() {
        for (AbstractConnector c : this._connectors) {
            c.setAccepting(true);
            if (this._endPointIdleTimeout <= 0L) continue;
            for (EndPoint endPoint : c.getConnectedEndPoints()) {
                endPoint.setIdleTimeout(c.getIdleTimeout());
            }
        }
    }

    @Override
    public void onAccepting(SelectableChannel channel) {
        try (AutoLock ignored = this._lock.lock();){
            ++this._pendingConnections;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Accepting ({}+{}) <= {} {}", this._pendingConnections, this._connections, this._maxNetworkConnections, channel);
            }
            if (this.lockedCheck()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Closing (limit reached) {}", (Object)channel);
                }
                IO.close(channel);
            }
        }
    }

    @Override
    public void onAcceptFailed(SelectableChannel channel, Throwable cause) {
        try (AutoLock ignored = this._lock.lock();){
            --this._pendingConnections;
            if (LOG.isDebugEnabled()) {
                LOG.atDebug().setCause(cause).log("Accept failed ({}+{}) <= {} {}", this._pendingConnections, this._connections, this._maxNetworkConnections, channel);
            }
            this.lockedCheck();
        }
    }

    @Override
    public void onAccepted(SelectableChannel channel) {
        try (AutoLock ignored = this._lock.lock();){
            --this._pendingConnections;
            ++this._connections;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Accepted ({}+{}) <= {} {}", this._pendingConnections, this._connections, this._maxNetworkConnections, channel);
            }
        }
    }

    @Override
    public void onClosed(SelectableChannel channel) {
        try (AutoLock ignored = this._lock.lock();){
            --this._connections;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Closed ({}+{}) <= {} {}", this._pendingConnections, this._connections, this._maxNetworkConnections, channel);
            }
            this.lockedCheck();
        }
    }
}

