/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.server;

import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import wiremock.org.eclipse.jetty.http.MimeTypes;
import wiremock.org.eclipse.jetty.server.Request;
import wiremock.org.eclipse.jetty.util.Attributes;
import wiremock.org.eclipse.jetty.util.Decorator;
import wiremock.org.eclipse.jetty.util.resource.Resource;

public interface Context
extends Attributes,
Decorator,
Executor {
    public String getContextPath();

    public ClassLoader getClassLoader();

    public Resource getBaseResource();

    public Request.Handler getErrorHandler();

    public List<String> getVirtualHosts();

    public MimeTypes getMimeTypes();

    @Override
    public void execute(Runnable var1);

    public void run(Runnable var1);

    public void run(Runnable var1, Request var2);

    default public String getPathInContext(String canonicallyEncodedPath) {
        return Context.getPathInContext(this.getContextPath(), canonicallyEncodedPath);
    }

    public File getTempDirectory();

    default public boolean isCrossContextDispatch(Request request) {
        return false;
    }

    default public String getCrossContextDispatchType(Request request) {
        return null;
    }

    public static String getPathInContext(String encodedContextPath, String encodedPath) {
        if (encodedContextPath.length() == 0 || "/".equals(encodedContextPath)) {
            return encodedPath;
        }
        if (encodedContextPath.length() > encodedPath.length() || !encodedPath.startsWith(encodedContextPath)) {
            return null;
        }
        if (encodedPath.length() == encodedContextPath.length()) {
            return "";
        }
        if (encodedPath.charAt(encodedContextPath.length()) != '/') {
            return null;
        }
        return encodedPath.substring(encodedContextPath.length());
    }

    public static class Wrapper
    implements Context {
        private final Context _wrapped;

        public Wrapper(Context context) {
            this._wrapped = context;
        }

        @Override
        public <T> T decorate(T o) {
            return this._wrapped.decorate(o);
        }

        @Override
        public void destroy(Object o) {
            this._wrapped.destroy(o);
        }

        @Override
        public String getContextPath() {
            return this._wrapped.getContextPath();
        }

        @Override
        public ClassLoader getClassLoader() {
            return this._wrapped.getClassLoader();
        }

        @Override
        public Resource getBaseResource() {
            return this._wrapped.getBaseResource();
        }

        @Override
        public Request.Handler getErrorHandler() {
            return this._wrapped.getErrorHandler();
        }

        @Override
        public List<String> getVirtualHosts() {
            return this._wrapped.getVirtualHosts();
        }

        @Override
        public MimeTypes getMimeTypes() {
            return this._wrapped.getMimeTypes();
        }

        @Override
        public void execute(Runnable task) {
            this._wrapped.execute(task);
        }

        @Override
        public Object removeAttribute(String name) {
            return this._wrapped.removeAttribute(name);
        }

        @Override
        public Object setAttribute(String name, Object attribute) {
            return this._wrapped.setAttribute(name, attribute);
        }

        @Override
        public Object getAttribute(String name) {
            return this._wrapped.getAttribute(name);
        }

        @Override
        public Set<String> getAttributeNameSet() {
            return this._wrapped.getAttributeNameSet();
        }

        @Override
        public void run(Runnable task) {
            this._wrapped.run(task);
        }

        @Override
        public void run(Runnable task, Request request) {
            this._wrapped.run(task, request);
        }

        @Override
        public File getTempDirectory() {
            return this._wrapped.getTempDirectory();
        }
    }
}

