/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.security.authentication;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Objects;
import wiremock.org.eclipse.jetty.io.EndPoint;
import wiremock.org.eclipse.jetty.security.AuthenticationState;
import wiremock.org.eclipse.jetty.security.ServerAuthException;
import wiremock.org.eclipse.jetty.security.UserIdentity;
import wiremock.org.eclipse.jetty.security.authentication.LoginAuthenticator;
import wiremock.org.eclipse.jetty.server.Request;
import wiremock.org.eclipse.jetty.server.Response;
import wiremock.org.eclipse.jetty.util.Callback;
import wiremock.org.eclipse.jetty.util.ssl.SslContextFactory;

public class SslClientCertAuthenticator
extends LoginAuthenticator {
    private final SslContextFactory sslContextFactory;
    private boolean validateCerts = true;

    public SslClientCertAuthenticator(SslContextFactory sslContextFactory) {
        this.sslContextFactory = Objects.requireNonNull(sslContextFactory);
    }

    @Override
    public String getAuthenticationType() {
        return "CLIENT_CERT";
    }

    @Override
    public AuthenticationState validateRequest(Request req, Response res, Callback callback) throws ServerAuthException {
        Object object = req.getAttribute("wiremock.org.eclipse.jetty.io.Endpoint.SslSessionData");
        if (!(object instanceof EndPoint.SslSessionData)) {
            return AuthenticationState.writeError(req, res, callback, 403);
        }
        EndPoint.SslSessionData sslSessionData = (EndPoint.SslSessionData)object;
        X509Certificate[] certs = sslSessionData.peerCertificates();
        try {
            if (certs != null && certs.length > 0) {
                if (this.validateCerts) {
                    this.sslContextFactory.validateCerts(certs);
                }
                for (X509Certificate cert : certs) {
                    String username;
                    UserIdentity user;
                    if (cert == null) continue;
                    Principal principal = cert.getSubjectDN();
                    if (principal == null) {
                        principal = cert.getIssuerDN();
                    }
                    if ((user = this.login(username = principal == null ? "clientcert" : principal.getName(), "", req, res)) != null) {
                        return new LoginAuthenticator.UserAuthenticationSucceeded(this.getAuthenticationType(), user);
                    }
                    user = this.login(username, null, req, res);
                    if (user != null) {
                        return new LoginAuthenticator.UserAuthenticationSucceeded(this.getAuthenticationType(), user);
                    }
                    char[] credential = Base64.getEncoder().encodeToString(cert.getSignature()).toCharArray();
                    user = this.login(username, credential, req, res);
                    if (user == null) continue;
                    return new LoginAuthenticator.UserAuthenticationSucceeded(this.getAuthenticationType(), user);
                }
            }
            if (!AuthenticationState.Deferred.isDeferred(res)) {
                return AuthenticationState.writeError(req, res, callback, 403);
            }
            return null;
        }
        catch (Exception e) {
            throw new ServerAuthException(e.getMessage());
        }
    }

    public boolean isValidateCerts() {
        return this.validateCerts;
    }

    public void setValidateCerts(boolean validateCerts) {
        this.validateCerts = validateCerts;
    }
}

