/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.security.authentication;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import wiremock.org.eclipse.jetty.security.AuthenticationState;
import wiremock.org.eclipse.jetty.security.ServerAuthException;
import wiremock.org.eclipse.jetty.security.UserIdentity;
import wiremock.org.eclipse.jetty.security.authentication.LoginAuthenticator;
import wiremock.org.eclipse.jetty.server.Request;
import wiremock.org.eclipse.jetty.server.Response;
import wiremock.org.eclipse.jetty.util.Callback;

public class BasicAuthenticator
extends LoginAuthenticator {
    private Charset _charset;

    public Charset getCharset() {
        return this._charset;
    }

    public void setCharset(Charset charset) {
        this._charset = charset;
    }

    @Override
    public String getAuthenticationType() {
        return "BASIC";
    }

    @Override
    public AuthenticationState validateRequest(Request req, Response res, Callback callback) throws ServerAuthException {
        String method;
        int space;
        String credentials = req.getHeaders().get(this.getAuthorizationHeader());
        if (credentials != null && (space = credentials.indexOf(32)) > 0 && "Basic".equalsIgnoreCase(method = credentials.substring(0, space))) {
            String password;
            String username;
            UserIdentity user;
            int i;
            credentials = credentials.substring(space + 1);
            Charset charset = this.getCharset();
            if (charset == null) {
                charset = StandardCharsets.ISO_8859_1;
            }
            if ((i = (credentials = new String(Base64.getDecoder().decode(credentials), charset)).indexOf(58)) > 0 && (user = this.login(username = credentials.substring(0, i), password = credentials.substring(i + 1), req, res)) != null) {
                return new LoginAuthenticator.UserAuthenticationSucceeded(this.getAuthenticationType(), user);
            }
        }
        if (res.isCommitted()) {
            return null;
        }
        String value = "Basic realm=\"" + this._loginService.getName() + "\"";
        Charset charset = this.getCharset();
        if (charset != null) {
            value = value + ", charset=\"" + charset.name() + "\"";
        }
        res.getHeaders().put(this.getChallengeHeader().asString(), value);
        Response.writeError(req, res, callback, this.getUnauthorizedStatusCode());
        return AuthenticationState.CHALLENGE;
    }

    public static String authorization(String user, String password) {
        return "Basic " + Base64.getEncoder().encodeToString((user + ":" + password).getBytes(StandardCharsets.ISO_8859_1));
    }
}

