/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.security;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import wiremock.org.eclipse.jetty.security.Authenticator;
import wiremock.org.eclipse.jetty.security.MultiAuthenticator;
import wiremock.org.eclipse.jetty.security.SecurityHandler;
import wiremock.org.eclipse.jetty.security.authentication.BasicAuthenticator;
import wiremock.org.eclipse.jetty.security.authentication.DigestAuthenticator;
import wiremock.org.eclipse.jetty.security.authentication.FormAuthenticator;
import wiremock.org.eclipse.jetty.security.authentication.SPNEGOAuthenticator;
import wiremock.org.eclipse.jetty.security.authentication.SslClientCertAuthenticator;
import wiremock.org.eclipse.jetty.server.Context;
import wiremock.org.eclipse.jetty.server.Server;
import wiremock.org.eclipse.jetty.util.StringUtil;
import wiremock.org.eclipse.jetty.util.ssl.SslContextFactory;

public class DefaultAuthenticatorFactory
implements Authenticator.Factory {
    @Override
    public Authenticator getAuthenticator(Server server, Context context, Authenticator.Configuration configuration) {
        String auth = StringUtil.asciiToUpperCase(configuration.getAuthenticationType());
        if (auth == null) {
            return null;
        }
        return switch (auth) {
            case "BASIC" -> new BasicAuthenticator();
            case "DIGEST" -> new DigestAuthenticator();
            case "FORM" -> new FormAuthenticator();
            case "SPNEGO" -> new SPNEGOAuthenticator();
            case "NEGOTIATE" -> new SPNEGOAuthenticator("NEGOTIATE");
            case "MULTI" -> this.getMultiAuthenticator(server, context, configuration);
            case "CLIENT_CERT", "CLIENT-CERT" -> {
                Collection<SslContextFactory> sslContextFactories = server.getBeans(SslContextFactory.class);
                if (sslContextFactories.size() != 1) {
                    throw new IllegalStateException("SslClientCertAuthenticator requires a single SslContextFactory instances.");
                }
                yield new SslClientCertAuthenticator(sslContextFactories.iterator().next());
            }
            default -> null;
        };
    }

    private Authenticator getMultiAuthenticator(Server server, Context context, Authenticator.Configuration configuration) {
        SecurityHandler securityHandler = SecurityHandler.getCurrentSecurityHandler();
        if (securityHandler == null) {
            return null;
        }
        String auth = configuration.getAuthenticationType();
        if ("MULTI".equalsIgnoreCase(auth)) {
            MultiAuthenticator multiAuthenticator = new MultiAuthenticator();
            String authenticatorConfig = configuration.getParameter("wiremock.org.eclipse.jetty.security.multi.authenticators");
            for (String config : StringUtil.csvSplit(authenticatorConfig)) {
                Authenticator.Factory factory;
                String[] parts = config.split(":");
                if (parts.length != 2) {
                    throw new IllegalArgumentException();
                }
                final String authType = parts[0].trim();
                String pathSpec = parts[1].trim();
                Authenticator.Configuration.Wrapper authConfig = new Authenticator.Configuration.Wrapper(this, configuration){
                    final /* synthetic */ DefaultAuthenticatorFactory this$0;
                    {
                        this.this$0 = this$0;
                        super(configuration);
                    }

                    @Override
                    public String getAuthenticationType() {
                        return authType;
                    }
                };
                Authenticator authenticator = null;
                List<Authenticator.Factory> authenticatorFactories = securityHandler.getKnownAuthenticatorFactories();
                Iterator<Authenticator.Factory> iterator = authenticatorFactories.iterator();
                while (iterator.hasNext() && (authenticator = (factory = iterator.next()).getAuthenticator(server, context, authConfig)) == null) {
                }
                if (authenticator == null) {
                    throw new IllegalStateException();
                }
                multiAuthenticator.addAuthenticator(pathSpec, authenticator);
            }
            return multiAuthenticator;
        }
        return null;
    }
}

