/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.security;

import java.util.Set;
import java.util.function.Function;
import wiremock.org.eclipse.jetty.security.AuthenticationState;
import wiremock.org.eclipse.jetty.security.Constraint;
import wiremock.org.eclipse.jetty.security.IdentityService;
import wiremock.org.eclipse.jetty.security.LoginService;
import wiremock.org.eclipse.jetty.security.ServerAuthException;
import wiremock.org.eclipse.jetty.server.Context;
import wiremock.org.eclipse.jetty.server.Request;
import wiremock.org.eclipse.jetty.server.Response;
import wiremock.org.eclipse.jetty.server.Server;
import wiremock.org.eclipse.jetty.server.Session;
import wiremock.org.eclipse.jetty.util.Callback;

public interface Authenticator {
    public static final String BASIC_AUTH = "BASIC";
    public static final String FORM_AUTH = "FORM";
    public static final String DIGEST_AUTH = "DIGEST";
    public static final String CERT_AUTH = "CLIENT_CERT";
    public static final String CERT_AUTH2 = "CLIENT-CERT";
    public static final String SPNEGO_AUTH = "SPNEGO";
    public static final String NEGOTIATE_AUTH = "NEGOTIATE";
    public static final String OPENID_AUTH = "OPENID";
    public static final String SIWE_AUTH = "SIWE";
    public static final String MULTI_AUTH = "MULTI";

    public void setConfiguration(Configuration var1);

    public String getAuthenticationType();

    default public Request prepareRequest(Request request, AuthenticationState authenticationState) {
        return request;
    }

    default public Constraint.Authorization getConstraintAuthentication(String pathInContext, Constraint.Authorization existing, Function<Boolean, Session> getSession) {
        return existing == null ? Constraint.Authorization.ALLOWED : existing;
    }

    public AuthenticationState validateRequest(Request var1, Response var2, Callback var3) throws ServerAuthException;

    public static class NoOp
    implements Authenticator {
        @Override
        public void setConfiguration(Configuration configuration) {
        }

        @Override
        public String getAuthenticationType() {
            return null;
        }

        @Override
        public AuthenticationState validateRequest(Request request, Response response, Callback callback) throws ServerAuthException {
            return null;
        }
    }

    public static interface Factory {
        public Authenticator getAuthenticator(Server var1, Context var2, Configuration var3);
    }

    public static interface Configuration {
        public String getAuthenticationType();

        public String getRealmName();

        public String getParameter(String var1);

        public Set<String> getParameterNames();

        public LoginService getLoginService();

        public IdentityService getIdentityService();

        public boolean isSessionRenewedOnAuthentication();

        public int getSessionMaxInactiveIntervalOnAuthentication();

        public static class Wrapper
        implements Configuration {
            private final Configuration _configuration;

            public Wrapper(Configuration configuration) {
                this._configuration = configuration;
            }

            @Override
            public String getAuthenticationType() {
                return this._configuration.getAuthenticationType();
            }

            @Override
            public String getRealmName() {
                return this._configuration.getRealmName();
            }

            @Override
            public String getParameter(String param) {
                return this._configuration.getParameter(param);
            }

            @Override
            public Set<String> getParameterNames() {
                return this._configuration.getParameterNames();
            }

            @Override
            public LoginService getLoginService() {
                return this._configuration.getLoginService();
            }

            @Override
            public IdentityService getIdentityService() {
                return this._configuration.getIdentityService();
            }

            @Override
            public boolean isSessionRenewedOnAuthentication() {
                return this._configuration.isSessionRenewedOnAuthentication();
            }

            @Override
            public int getSessionMaxInactiveIntervalOnAuthentication() {
                return this._configuration.getSessionMaxInactiveIntervalOnAuthentication();
            }
        }
    }
}

