/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.io.ssl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import wiremock.org.eclipse.jetty.io.ByteBufferPool;
import wiremock.org.eclipse.jetty.io.ClientConnectionFactory;
import wiremock.org.eclipse.jetty.io.ClientConnector;
import wiremock.org.eclipse.jetty.io.Connection;
import wiremock.org.eclipse.jetty.io.EndPoint;
import wiremock.org.eclipse.jetty.io.ssl.SslConnection;
import wiremock.org.eclipse.jetty.io.ssl.SslHandshakeListener;
import wiremock.org.eclipse.jetty.util.component.ContainerLifeCycle;
import wiremock.org.eclipse.jetty.util.ssl.SslContextFactory;

public class SslClientConnectionFactory
extends ClientConnectionFactory.Wrapper {
    private final SslContextFactory.Client _sslContextFactory;
    private final ByteBufferPool _byteBufferPool;
    private final Executor _executor;
    private boolean _directBuffersForEncryption = true;
    private boolean _directBuffersForDecryption = true;
    private boolean _requireCloseMessage;

    public SslClientConnectionFactory(SslContextFactory.Client sslContextFactory, ByteBufferPool byteBufferPool, Executor executor, ClientConnectionFactory connectionFactory) {
        super(connectionFactory);
        this._sslContextFactory = Objects.requireNonNull(sslContextFactory, "Missing SslContextFactory");
        this._byteBufferPool = byteBufferPool;
        this._executor = executor;
    }

    public SslContextFactory.Client getSslContextFactory() {
        return this._sslContextFactory;
    }

    public ByteBufferPool getByteBufferPool() {
        return this._byteBufferPool;
    }

    public Executor getExecutor() {
        return this._executor;
    }

    public void setDirectBuffersForEncryption(boolean useDirectBuffers) {
        this._directBuffersForEncryption = useDirectBuffers;
    }

    public void setDirectBuffersForDecryption(boolean useDirectBuffers) {
        this._directBuffersForDecryption = useDirectBuffers;
    }

    public boolean isDirectBuffersForDecryption() {
        return this._directBuffersForDecryption;
    }

    public boolean isDirectBuffersForEncryption() {
        return this._directBuffersForEncryption;
    }

    public boolean isRequireCloseMessage() {
        return this._requireCloseMessage;
    }

    public void setRequireCloseMessage(boolean requireCloseMessage) {
        this._requireCloseMessage = requireCloseMessage;
    }

    @Override
    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        SSLEngine engine;
        SocketAddress remote = (SocketAddress)context.get(ClientConnector.REMOTE_SOCKET_ADDRESS_CONTEXT_KEY);
        if (remote instanceof InetSocketAddress) {
            InetSocketAddress inetRemote = (InetSocketAddress)remote;
            String host = inetRemote.getHostString();
            int port = inetRemote.getPort();
            engine = this._sslContextFactory instanceof SslEngineFactory ? ((SslEngineFactory)((Object)this._sslContextFactory)).newSslEngine(host, port, context) : this._sslContextFactory.newSSLEngine(host, port);
        } else {
            engine = this._sslContextFactory.newSSLEngine();
        }
        engine.setUseClientMode(true);
        context.put(SSLEngine.class.getName(), engine);
        SslConnection sslConnection = this.newSslConnection(endPoint, engine);
        SslConnection.SslEndPoint appEndPoint = sslConnection.getSslEndPoint();
        appEndPoint.setConnection(this.getWrapped().newConnection(appEndPoint, context));
        sslConnection.addHandshakeListener(new HTTPSHandshakeListener(context));
        this.customize(sslConnection, context);
        return sslConnection;
    }

    protected SslConnection newSslConnection(EndPoint endPoint, SSLEngine engine) {
        return new SslConnection(this.getByteBufferPool(), this.getExecutor(), this.getSslContextFactory(), endPoint, engine, this.isDirectBuffersForEncryption(), this.isDirectBuffersForDecryption());
    }

    @Override
    public Connection customize(Connection connection, Map<String, Object> context) {
        if (connection instanceof SslConnection) {
            SslConnection sslConnection = (SslConnection)connection;
            sslConnection.setRenegotiationAllowed(this._sslContextFactory.isRenegotiationAllowed());
            sslConnection.setRenegotiationLimit(this._sslContextFactory.getRenegotiationLimit());
            sslConnection.setRequireCloseMessage(this.isRequireCloseMessage());
            ContainerLifeCycle client = (ContainerLifeCycle)context.get("wiremock.org.eclipse.jetty.client.HttpClient");
            if (client != null) {
                client.getBeans(SslHandshakeListener.class).forEach(sslConnection::addHandshakeListener);
            }
        }
        return super.customize(connection, context);
    }

    public static interface SslEngineFactory {
        public SSLEngine newSslEngine(String var1, int var2, Map<String, Object> var3);
    }

    private class HTTPSHandshakeListener
    implements SslHandshakeListener {
        private final Map<String, Object> context;

        private HTTPSHandshakeListener(Map<String, Object> context) {
            this.context = context;
        }

        @Override
        public void handshakeSucceeded(SslHandshakeListener.Event event) throws SSLException {
            SocketAddress address;
            HostnameVerifier verifier = SslClientConnectionFactory.this._sslContextFactory.getHostnameVerifier();
            if (verifier != null && (address = (SocketAddress)this.context.get(ClientConnector.REMOTE_SOCKET_ADDRESS_CONTEXT_KEY)) instanceof InetSocketAddress) {
                String host = ((InetSocketAddress)address).getHostString();
                try {
                    if (!verifier.verify(host, event.getSSLEngine().getSession())) {
                        throw new SSLPeerUnverifiedException("Host name verification failed for host: " + host);
                    }
                }
                catch (SSLException x) {
                    throw x;
                }
                catch (Throwable x) {
                    throw (SSLException)new SSLPeerUnverifiedException("Host name verification failed for host: " + host).initCause(x);
                }
            }
        }
    }
}

