/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.io.internal;

import java.nio.ByteBuffer;
import wiremock.org.eclipse.jetty.io.Content;
import wiremock.org.eclipse.jetty.io.RetainableByteBuffer;
import wiremock.org.eclipse.jetty.util.Promise;
import wiremock.org.eclipse.jetty.util.thread.Invocable;

public class ContentSourceByteBuffer
implements Invocable.Task {
    private final RetainableByteBuffer.DynamicCapacity dynamic = new RetainableByteBuffer.DynamicCapacity();
    private final Content.Source source;
    private final Promise<ByteBuffer> promise;

    public ContentSourceByteBuffer(Content.Source source, Promise<ByteBuffer> promise) {
        this.source = source;
        this.promise = promise;
    }

    @Override
    public void run() {
        Content.Chunk chunk;
        do {
            if ((chunk = this.source.read()) == null) {
                this.source.demand(this);
                return;
            }
            if (Content.Chunk.isFailure(chunk)) {
                this.promise.failed(chunk.getFailure());
                if (!chunk.isLast()) {
                    this.source.fail(chunk.getFailure());
                }
                return;
            }
            this.dynamic.append(chunk.getByteBuffer().slice());
            chunk.release();
        } while (!chunk.isLast());
        ByteBuffer dynamicResult = this.dynamic.getByteBuffer();
        this.dynamic.release();
        this.promise.succeeded(dynamicResult);
    }

    @Override
    public Invocable.InvocationType getInvocationType() {
        return Invocable.getInvocationType(this.promise);
    }
}

