/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.io.internal;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import wiremock.org.eclipse.jetty.io.Content;
import wiremock.org.eclipse.jetty.io.Retainable;
import wiremock.org.eclipse.jetty.io.RetainableByteBuffer;
import wiremock.org.eclipse.jetty.util.BufferUtil;
import wiremock.org.eclipse.jetty.util.TypeUtil;

public abstract class ByteBufferChunk
extends RetainableByteBuffer.FixedCapacity
implements Content.Chunk {
    private final boolean last;

    public ByteBufferChunk(ByteBuffer byteBuffer, boolean last) {
        super(Objects.requireNonNull(byteBuffer));
        this.last = last;
    }

    @Override
    public boolean isLast() {
        return this.last;
    }

    @Override
    public String toString() {
        return "%s@%x[l=%b,b=%s]".formatted(TypeUtil.toShortName(this.getClass()), this.hashCode(), this.isLast(), BufferUtil.toDetailString(this.getByteBuffer()));
    }

    public static class WithRetainableByteBuffer
    extends RetainableByteBuffer.Wrapper
    implements Content.Chunk {
        private final boolean last;

        public WithRetainableByteBuffer(RetainableByteBuffer wrapped, boolean last) {
            super(wrapped);
            this.last = last;
        }

        @Override
        public boolean isLast() {
            return this.last;
        }

        @Override
        public String toString() {
            return "%s@%x[l=%b,b=%s]".formatted(TypeUtil.toShortName(this.getClass()), this.hashCode(), this.isLast(), this.getWrapped().toDetailString());
        }
    }

    public static class WithRetainable
    extends ByteBufferChunk {
        private final Retainable retainable;

        public WithRetainable(ByteBuffer byteBuffer, boolean last, Retainable retainable) {
            super(byteBuffer, last);
            this.retainable = Objects.requireNonNull(retainable);
        }

        @Override
        public boolean isRetained() {
            return this.retainable.isRetained();
        }

        @Override
        public boolean canRetain() {
            return this.retainable.canRetain();
        }

        @Override
        public void retain() {
            this.retainable.retain();
        }

        @Override
        public boolean release() {
            return this.retainable.release();
        }

        @Override
        public String toString() {
            return "%s[%s]".formatted(super.toString(), this.retainable);
        }
    }

    public static class ReleasedByConsumer
    extends WithReferenceCount {
        private final AtomicReference<Consumer<ByteBuffer>> releaser;

        public ReleasedByConsumer(ByteBuffer byteBuffer, boolean last, Consumer<ByteBuffer> releaser) {
            super(byteBuffer, last);
            this.releaser = new AtomicReference<Consumer<ByteBuffer>>(releaser);
        }

        @Override
        public boolean release() {
            Consumer consumer;
            boolean released = super.release();
            if (released && (consumer = (Consumer)this.releaser.getAndSet(null)) != null) {
                consumer.accept(this.getByteBuffer());
            }
            return released;
        }
    }

    public static class ReleasedByRunnable
    extends WithReferenceCount {
        private final AtomicReference<Runnable> releaser;

        public ReleasedByRunnable(ByteBuffer byteBuffer, boolean last, Runnable releaser) {
            super(byteBuffer, last);
            this.releaser = new AtomicReference<Runnable>(releaser);
        }

        @Override
        public boolean release() {
            Runnable runnable;
            boolean released = super.release();
            if (released && (runnable = (Runnable)this.releaser.getAndSet(null)) != null) {
                runnable.run();
            }
            return released;
        }
    }

    public static class WithReferenceCount
    extends ByteBufferChunk {
        private final Retainable.ReferenceCounter references = new Retainable.ReferenceCounter();

        public WithReferenceCount(ByteBuffer byteBuffer, boolean last) {
            super(byteBuffer, last);
        }

        @Override
        public boolean isRetained() {
            return this.references.isRetained();
        }

        @Override
        public boolean canRetain() {
            return true;
        }

        @Override
        public void retain() {
            this.references.retain();
        }

        @Override
        public boolean release() {
            return this.references.release();
        }

        @Override
        public String toString() {
            return "%s[rc=%d]".formatted(super.toString(), this.references.get());
        }
    }
}

