/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.io.content;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import wiremock.org.eclipse.jetty.io.Content;
import wiremock.org.eclipse.jetty.util.Blocker;
import wiremock.org.eclipse.jetty.util.IO;

public class ContentSourceInputStream
extends InputStream {
    private final Blocker.Shared blocking = new Blocker.Shared();
    private final Content.Source content;
    private byte[] oneByte;
    private Content.Chunk chunk;

    public ContentSourceInputStream(Content.Source content) {
        this.content = Objects.requireNonNull(content);
    }

    @Override
    public int read() throws IOException {
        int read;
        if (this.oneByte == null) {
            this.oneByte = new byte[1];
        }
        return (read = this.read(this.oneByte, 0, 1)) < 0 ? -1 : this.oneByte[0] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        while (true) {
            if (this.chunk != null) {
                if (Content.Chunk.isFailure(this.chunk)) {
                    Content.Chunk failure = this.chunk;
                    this.chunk = Content.Chunk.next(failure);
                    throw IO.rethrow(failure.getFailure());
                }
                ByteBuffer byteBuffer = this.chunk.getByteBuffer();
                if (this.chunk.isLast() && !byteBuffer.hasRemaining()) {
                    return -1;
                }
                int l = Math.min(byteBuffer.remaining(), len);
                byteBuffer.get(b, off, l);
                if (!byteBuffer.hasRemaining()) {
                    this.chunk.release();
                    this.chunk = this.chunk.isLast() ? Content.Chunk.EOF : null;
                }
                return l;
            }
            do {
                this.chunk = this.content.read();
            } while (this.chunk != null && !this.chunk.hasRemaining() && !this.chunk.isLast() && !Content.Chunk.isFailure(this.chunk));
            if (this.chunk != null) continue;
            Blocker.Runnable callback = this.blocking.runnable();
            try {
                this.content.demand(callback);
                callback.block();
                continue;
            }
            finally {
                if (callback == null) continue;
                callback.close();
                continue;
            }
            break;
        }
    }

    @Override
    public int available() throws IOException {
        ByteBuffer available;
        ByteBuffer byteBuffer = available = this.chunk == null ? null : this.chunk.getByteBuffer();
        if (available != null) {
            return available.remaining();
        }
        return 0;
    }

    @Override
    public void close() throws IOException {
        if (this.chunk == Content.Chunk.EOF || Content.Chunk.isFailure(this.chunk, true)) {
            return;
        }
        boolean contentSkipped = false;
        if (this.chunk != null) {
            contentSkipped = this.chunk.hasRemaining();
            this.chunk.release();
            this.chunk = Content.Chunk.next(this.chunk);
        }
        if (!contentSkipped && this.chunk == null) {
            this.chunk = this.content.read();
            if (this.chunk != null) {
                if (Content.Chunk.isFailure(this.chunk)) {
                    Content.Chunk failure = this.chunk;
                    this.chunk = Content.Chunk.next(failure);
                    if (!failure.isLast()) {
                        this.content.fail(failure.getFailure());
                    }
                    throw IO.rethrow(failure.getFailure());
                }
                contentSkipped = this.chunk.hasRemaining();
                this.chunk.release();
                this.chunk = Content.Chunk.next(this.chunk);
            }
        }
        if (!contentSkipped && this.chunk != null && this.chunk.isLast()) {
            return;
        }
        IOException closed = new IOException("closed before EOF");
        this.chunk = Content.Chunk.from(closed);
        this.content.fail(closed);
    }
}

