/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.io;

import java.io.IOException;
import java.net.SocketAddress;
import java.net.StandardProtocolFamily;
import java.net.UnixDomainSocketAddress;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import wiremock.org.eclipse.jetty.io.ClientConnectionFactory;
import wiremock.org.eclipse.jetty.io.ClientConnector;
import wiremock.org.eclipse.jetty.io.Connection;
import wiremock.org.eclipse.jetty.io.DatagramChannelEndPoint;
import wiremock.org.eclipse.jetty.io.EndPoint;
import wiremock.org.eclipse.jetty.io.ManagedSelector;
import wiremock.org.eclipse.jetty.io.SocketChannelEndPoint;
import wiremock.org.eclipse.jetty.util.TypeUtil;
import wiremock.org.eclipse.jetty.util.thread.Scheduler;

public interface Transport {
    public static final String CONTEXT_KEY = Transport.class.getName();
    public static final Transport TCP_IP = new TCPIP();
    public static final Transport UDP_IP = new UDPIP();

    default public boolean isIntrinsicallySecure() {
        return false;
    }

    default public boolean requiresDomainNameResolution() {
        return false;
    }

    default public void connect(SocketAddress socketAddress, Map<String, Object> context) {
    }

    default public SocketAddress getSocketAddress() {
        return null;
    }

    default public SelectableChannel newSelectableChannel() throws IOException {
        return null;
    }

    default public EndPoint newEndPoint(Scheduler scheduler, ManagedSelector selector, SelectableChannel selectable, SelectionKey selectionKey) {
        return null;
    }

    default public ClientConnectionFactory newClientConnectionFactory(ClientConnector connector, ClientConnectionFactory factory) {
        return factory;
    }

    default public Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        ClientConnectionFactory factory = (ClientConnectionFactory)context.get(ClientConnectionFactory.CONTEXT_KEY);
        return factory.newConnection(endPoint, context);
    }

    public int hashCode();

    public boolean equals(Object var1);

    public static class TCPIP
    extends IP {
        protected TCPIP() {
        }

        @Override
        public SelectableChannel newSelectableChannel() throws IOException {
            return SocketChannel.open();
        }

        @Override
        public EndPoint newEndPoint(Scheduler scheduler, ManagedSelector selector, SelectableChannel selectable, SelectionKey selectionKey) {
            return new SocketChannelEndPoint((SocketChannel)selectable, selector, selectionKey, scheduler);
        }
    }

    public static class UDPIP
    extends IP {
        protected UDPIP() {
        }

        @Override
        public SelectableChannel newSelectableChannel() throws IOException {
            return DatagramChannel.open();
        }

        @Override
        public EndPoint newEndPoint(Scheduler scheduler, ManagedSelector selector, SelectableChannel selectable, SelectionKey selectionKey) {
            return new DatagramChannelEndPoint((DatagramChannel)selectable, selector, selectionKey, scheduler);
        }
    }

    public static class Wrapper
    implements Transport {
        private final Transport wrapped;

        public Wrapper(Transport wrapped) {
            this.wrapped = Objects.requireNonNull(wrapped);
        }

        public Transport getWrapped() {
            return this.wrapped;
        }

        public Transport unwrap() {
            Transport result = this.getWrapped();
            while (result instanceof Wrapper) {
                Wrapper wrapper = (Wrapper)result;
                result = wrapper.getWrapped();
            }
            return result;
        }

        @Override
        public boolean isIntrinsicallySecure() {
            return this.wrapped.isIntrinsicallySecure();
        }

        @Override
        public boolean requiresDomainNameResolution() {
            return this.wrapped.requiresDomainNameResolution();
        }

        @Override
        public void connect(SocketAddress socketAddress, Map<String, Object> context) {
            this.getWrapped().connect(socketAddress, context);
        }

        @Override
        public SocketAddress getSocketAddress() {
            return this.wrapped.getSocketAddress();
        }

        @Override
        public SelectableChannel newSelectableChannel() throws IOException {
            return this.getWrapped().newSelectableChannel();
        }

        @Override
        public EndPoint newEndPoint(Scheduler scheduler, ManagedSelector selector, SelectableChannel selectable, SelectionKey selectionKey) {
            return this.getWrapped().newEndPoint(scheduler, selector, selectable, selectionKey);
        }

        @Override
        public ClientConnectionFactory newClientConnectionFactory(ClientConnector connector, ClientConnectionFactory factory) {
            return this.getWrapped().newClientConnectionFactory(connector, factory);
        }

        @Override
        public Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
            return this.getWrapped().newConnection(endPoint, context);
        }

        public String toString() {
            return "%s@%x[%s]".formatted(TypeUtil.toShortName(this.getClass()), this.hashCode(), this.getWrapped());
        }
    }

    public static class UDPUnix
    extends Unix {
        public UDPUnix(Path path) {
            super(path);
        }

        @Override
        public SelectableChannel newSelectableChannel() throws IOException {
            return DatagramChannel.open(StandardProtocolFamily.UNIX);
        }

        @Override
        public EndPoint newEndPoint(Scheduler scheduler, ManagedSelector selector, SelectableChannel selectable, SelectionKey selectionKey) {
            return new DatagramChannelEndPoint((DatagramChannel)selectable, selector, selectionKey, scheduler);
        }
    }

    public static class TCPUnix
    extends Unix {
        public TCPUnix(Path path) {
            super(path);
        }

        @Override
        public SelectableChannel newSelectableChannel() throws IOException {
            return SocketChannel.open(StandardProtocolFamily.UNIX);
        }

        @Override
        public EndPoint newEndPoint(Scheduler scheduler, ManagedSelector selector, SelectableChannel selectable, SelectionKey selectionKey) {
            return new SocketChannelEndPoint((SocketChannel)selectable, selector, selectionKey, scheduler);
        }
    }

    public static abstract class Unix
    extends Socket {
        private final UnixDomainSocketAddress socketAddress;

        protected Unix(Path path) {
            this.socketAddress = UnixDomainSocketAddress.of(path);
        }

        @Override
        public SocketAddress getSocketAddress() {
            return this.socketAddress;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.socketAddress);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Unix) {
                Unix unix = (Unix)obj;
                return Objects.equals(this.socketAddress, unix.socketAddress);
            }
            return false;
        }

        @Override
        public String toString() {
            return "%s[%s]".formatted(super.toString(), this.socketAddress.getPath());
        }
    }

    public static abstract class IP
    extends Socket {
        @Override
        public boolean requiresDomainNameResolution() {
            return true;
        }
    }

    public static abstract class Socket
    implements Transport {
        @Override
        public void connect(SocketAddress socketAddress, Map<String, Object> context) {
            ClientConnector connector = (ClientConnector)context.get(ClientConnector.CONTEXT_KEY);
            connector.connect(socketAddress, context);
        }

        public String toString() {
            return "%s@%x".formatted(TypeUtil.toShortName(this.getClass()), this.hashCode());
        }
    }
}

