/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.io;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ReadPendingException;
import java.nio.channels.WritePendingException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLSession;
import wiremock.org.eclipse.jetty.io.Connection;
import wiremock.org.eclipse.jetty.io.Content;
import wiremock.org.eclipse.jetty.util.Callback;
import wiremock.org.eclipse.jetty.util.IO;
import wiremock.org.eclipse.jetty.util.ssl.SslContextFactory;

public interface EndPoint
extends Closeable,
Content.Sink {
    public static final SocketAddress EOF = InetSocketAddress.createUnresolved("", 0);

    default public SocketAddress getLocalSocketAddress() {
        return null;
    }

    default public SocketAddress getRemoteSocketAddress() {
        return null;
    }

    public boolean isOpen();

    public long getCreatedTimeStamp();

    public void shutdownOutput();

    public boolean isOutputShutdown();

    public boolean isInputShutdown();

    @Override
    default public void close() {
        this.close(null);
    }

    public void close(Throwable var1);

    default public int fill(ByteBuffer buffer) throws IOException {
        throw new UnsupportedOperationException();
    }

    default public SocketAddress receive(ByteBuffer buffer) throws IOException {
        int filled = this.fill(buffer);
        if (filled < 0) {
            return EOF;
        }
        if (filled == 0) {
            return null;
        }
        return this.getRemoteSocketAddress();
    }

    default public boolean flush(ByteBuffer ... buffer) throws IOException {
        throw new UnsupportedOperationException();
    }

    default public boolean send(SocketAddress address, ByteBuffer ... buffers) throws IOException {
        return this.flush(buffers);
    }

    public Object getTransport();

    public long getIdleTimeout();

    public void setIdleTimeout(long var1);

    public void fillInterested(Callback var1) throws ReadPendingException;

    public boolean tryFillInterested(Callback var1);

    public boolean isFillInterested();

    default public void write(Callback callback, ByteBuffer ... buffers) throws WritePendingException {
        throw new UnsupportedOperationException();
    }

    default public void write(Callback callback, SocketAddress address, ByteBuffer ... buffers) throws WritePendingException {
        this.write(callback, buffers);
    }

    @Override
    default public void write(boolean last, ByteBuffer byteBuffer, Callback callback) {
        if (last) {
            this.write(Callback.from(() -> {
                try {
                    this.close();
                    callback.succeeded();
                }
                catch (Throwable t) {
                    callback.failed(t);
                }
            }, x -> {
                IO.close(this);
                callback.failed((Throwable)x);
            }), byteBuffer);
        } else {
            this.write(callback, byteBuffer);
        }
    }

    public Callback cancelWrite(Throwable var1);

    public Connection getConnection();

    public void setConnection(Connection var1);

    public void onOpen();

    public void onClose(Throwable var1);

    public void upgrade(Connection var1);

    default public SslSessionData getSslSessionData() {
        return null;
    }

    default public boolean isSecure() {
        return this.getSslSessionData() != null;
    }

    public static interface SslSessionData {
        public static final String ATTRIBUTE = "wiremock.org.eclipse.jetty.io.Endpoint.SslSessionData";

        public SSLSession sslSession();

        public String sslSessionId();

        public String cipherSuite();

        public X509Certificate[] peerCertificates();

        default public int keySize() {
            String cipherSuite = this.cipherSuite();
            return cipherSuite == null ? 0 : SslContextFactory.deduceKeyLength(cipherSuite);
        }

        public static SslSessionData from(final SSLSession sslSession, final String sslSessionId, final String cipherSuite, final X509Certificate[] peerCertificates) {
            return new SslSessionData(){

                @Override
                public SSLSession sslSession() {
                    return sslSession;
                }

                @Override
                public String sslSessionId() {
                    return sslSessionId;
                }

                @Override
                public String cipherSuite() {
                    return cipherSuite;
                }

                @Override
                public X509Certificate[] peerCertificates() {
                    return peerCertificates;
                }
            };
        }

        public static SslSessionData withCipherSuite(SslSessionData baseData, String cipherSuite) {
            return baseData == null ? SslSessionData.from(null, null, cipherSuite, null) : SslSessionData.from(baseData.sslSession(), baseData.sslSessionId(), cipherSuite != null ? cipherSuite : baseData.cipherSuite(), baseData.peerCertificates());
        }

        public static SslSessionData withSslSessionId(SslSessionData baseData, String sslSessionId) {
            return baseData == null ? SslSessionData.from(null, sslSessionId, null, null) : SslSessionData.from(baseData.sslSession(), sslSessionId != null ? sslSessionId : baseData.sslSessionId(), baseData.cipherSuite(), baseData.peerCertificates());
        }
    }

    public static interface Pipe {
        public EndPoint getLocalEndPoint();

        public EndPoint getRemoteEndPoint();
    }

    public static interface Wrapper {
        public EndPoint unwrap();
    }
}

