/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.io;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.DatagramChannel;
import java.nio.channels.NetworkChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.time.Duration;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import wiremock.org.eclipse.jetty.io.ArrayByteBufferPool;
import wiremock.org.eclipse.jetty.io.ByteBufferPool;
import wiremock.org.eclipse.jetty.io.ClientConnectionFactory;
import wiremock.org.eclipse.jetty.io.Connection;
import wiremock.org.eclipse.jetty.io.EndPoint;
import wiremock.org.eclipse.jetty.io.ManagedSelector;
import wiremock.org.eclipse.jetty.io.SelectorManager;
import wiremock.org.eclipse.jetty.io.Transport;
import wiremock.org.eclipse.jetty.io.ssl.SslClientConnectionFactory;
import wiremock.org.eclipse.jetty.util.IO;
import wiremock.org.eclipse.jetty.util.Promise;
import wiremock.org.eclipse.jetty.util.annotation.ManagedAttribute;
import wiremock.org.eclipse.jetty.util.annotation.ManagedObject;
import wiremock.org.eclipse.jetty.util.component.ContainerLifeCycle;
import wiremock.org.eclipse.jetty.util.ssl.SslContextFactory;
import wiremock.org.eclipse.jetty.util.thread.QueuedThreadPool;
import wiremock.org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import wiremock.org.eclipse.jetty.util.thread.Scheduler;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

@ManagedObject
public class ClientConnector
extends ContainerLifeCycle {
    public static final String CONTEXT_KEY = ClientConnector.class.getName();
    public static final String APPLICATION_PROTOCOL_CONTEXT_KEY = CONTEXT_KEY + ".applicationProtocol";
    public static final String APPLICATION_PROTOCOLS_CONTEXT_KEY = CONTEXT_KEY + ".applicationProtocols";
    public static final String CONNECTION_PROMISE_CONTEXT_KEY = Connection.class.getName() + ".promise";
    public static final String HTTP_CLIENT_CONTEXT_KEY = "wiremock.org.eclipse.jetty.client.HttpClient";
    public static final String REMOTE_SOCKET_ADDRESS_CONTEXT_KEY = CONTEXT_KEY + ".remoteSocketAddress";
    public static final String SSL_CONTEXT_FACTORY_CONTEXT_KEY = CONTEXT_KEY + ".sslContextFactory";
    private static final Logger LOG = LoggerFactory.getLogger(ClientConnector.class);
    private final List<ConnectListener> listeners = new CopyOnWriteArrayList<ConnectListener>();
    private Executor executor;
    private Scheduler scheduler;
    private ByteBufferPool byteBufferPool;
    private SslContextFactory.Client sslContextFactory;
    private SelectorManager selectorManager;
    private int selectors = 1;
    private boolean connectBlocking;
    private Duration connectTimeout = Duration.ofSeconds(5L);
    private Duration idleTimeout = Duration.ofSeconds(30L);
    private SocketAddress bindAddress;
    private boolean tcpNoDelay = true;
    private boolean reuseAddress = true;
    private boolean reusePort;
    private int receiveBufferSize = -1;
    private int sendBufferSize = -1;

    public SelectorManager getSelectorManager() {
        return this.selectorManager;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        if (this.isStarted()) {
            throw new IllegalStateException();
        }
        this.updateBean(this.executor, executor);
        this.executor = executor;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        if (this.isStarted()) {
            throw new IllegalStateException();
        }
        this.updateBean(this.scheduler, scheduler);
        this.scheduler = scheduler;
    }

    public ByteBufferPool getByteBufferPool() {
        return this.byteBufferPool;
    }

    public void setByteBufferPool(ByteBufferPool byteBufferPool) {
        if (this.isStarted()) {
            throw new IllegalStateException();
        }
        this.updateBean(this.byteBufferPool, byteBufferPool);
        this.byteBufferPool = byteBufferPool;
    }

    public SslContextFactory.Client getSslContextFactory() {
        return this.sslContextFactory;
    }

    public void setSslContextFactory(SslContextFactory.Client sslContextFactory) {
        if (this.isStarted()) {
            throw new IllegalStateException();
        }
        this.updateBean(this.sslContextFactory, sslContextFactory);
        this.sslContextFactory = sslContextFactory;
    }

    @ManagedAttribute(value="The number of NIO selectors")
    public int getSelectors() {
        return this.selectors;
    }

    public void setSelectors(int selectors) {
        if (this.isStarted()) {
            throw new IllegalStateException();
        }
        this.selectors = selectors;
    }

    @ManagedAttribute(value="Whether connect operations are performed in blocking mode")
    public boolean isConnectBlocking() {
        return this.connectBlocking;
    }

    public void setConnectBlocking(boolean connectBlocking) {
        this.connectBlocking = connectBlocking;
    }

    @ManagedAttribute(value="The timeout of connect operations")
    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
        if (this.selectorManager != null) {
            this.selectorManager.setConnectTimeout(connectTimeout.toMillis());
        }
    }

    @ManagedAttribute(value="The duration for which a connection can be idle")
    public Duration getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(Duration idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    @ManagedAttribute(value="The socket address to bind sockets to before the connect operation")
    public SocketAddress getBindAddress() {
        return this.bindAddress;
    }

    public void setBindAddress(SocketAddress bindAddress) {
        this.bindAddress = bindAddress;
    }

    @ManagedAttribute(value="Whether small TCP packets are sent without delay")
    public boolean isTCPNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTCPNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    @ManagedAttribute(value="Whether rebinding is allowed with sockets in tear-down states")
    public boolean getReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    @ManagedAttribute(value="Whether binding to same host and port is allowed")
    public boolean isReusePort() {
        return this.reusePort;
    }

    public void setReusePort(boolean reusePort) {
        this.reusePort = reusePort;
    }

    @ManagedAttribute(value="The receive buffer size in bytes")
    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    @ManagedAttribute(value="The send buffer size in bytes")
    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    @Override
    protected void doStart() throws Exception {
        if (this.executor == null) {
            QueuedThreadPool clientThreads = new QueuedThreadPool();
            clientThreads.setName(String.format("client-pool@%x", this.hashCode()));
            this.setExecutor(clientThreads);
        }
        if (this.scheduler == null) {
            this.setScheduler(new ScheduledExecutorScheduler(String.format("client-scheduler@%x", this.hashCode()), false));
        }
        if (this.byteBufferPool == null) {
            this.setByteBufferPool(new ArrayByteBufferPool());
        }
        if (this.sslContextFactory == null) {
            this.setSslContextFactory(this.newSslContextFactory());
        }
        this.selectorManager = this.newSelectorManager();
        this.selectorManager.setConnectTimeout(this.getConnectTimeout().toMillis());
        this.addBean(this.selectorManager);
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        this.removeBean(this.selectorManager);
    }

    protected SslContextFactory.Client newSslContextFactory() {
        SslContextFactory.Client sslContextFactory = new SslContextFactory.Client(false);
        sslContextFactory.setEndpointIdentificationAlgorithm("HTTPS");
        return sslContextFactory;
    }

    protected SelectorManager newSelectorManager() {
        return new ClientSelectorManager(this.getExecutor(), this.getScheduler(), this.getSelectors());
    }

    public ClientConnectionFactory newSslClientConnectionFactory(SslContextFactory.Client sslContextFactory, ClientConnectionFactory connectionFactory) {
        if (sslContextFactory == null) {
            sslContextFactory = this.getSslContextFactory();
        }
        return new SslClientConnectionFactory(sslContextFactory, this.getByteBufferPool(), this.getExecutor(), connectionFactory);
    }

    public void connect(SocketAddress address, Map<String, Object> context) {
        SelectableChannel channel = null;
        try {
            context.put(CONTEXT_KEY, this);
            Transport transport = (Transport)context.get(Transport.CONTEXT_KEY);
            if (address == null) {
                address = transport.getSocketAddress();
            }
            if (address != null) {
                context.put(REMOTE_SOCKET_ADDRESS_CONTEXT_KEY, address);
            }
            channel = transport.newSelectableChannel();
            this.configure(channel);
            if (channel instanceof NetworkChannel) {
                NetworkChannel networkChannel = (NetworkChannel)((Object)channel);
                SocketAddress bindAddress = this.getBindAddress();
                if (bindAddress != null) {
                    this.bind(networkChannel, bindAddress);
                } else if (networkChannel instanceof DatagramChannel) {
                    this.bind(networkChannel, null);
                }
            }
            boolean connected = true;
            if (channel instanceof SocketChannel) {
                boolean blocking;
                SocketChannel socketChannel = (SocketChannel)channel;
                boolean bl = blocking = this.isConnectBlocking() && address instanceof InetSocketAddress;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Connecting {} to {}", (Object)(blocking ? "blocking" : "non-blocking"), (Object)address);
                }
                this.notifyConnectBegin(socketChannel, address);
                if (blocking) {
                    socketChannel.socket().connect(address, (int)this.getConnectTimeout().toMillis());
                    this.notifyConnectSuccess(socketChannel);
                    socketChannel.configureBlocking(false);
                } else {
                    socketChannel.configureBlocking(false);
                    connected = socketChannel.connect(address);
                    if (connected) {
                        this.notifyConnectSuccess(socketChannel);
                    }
                }
            } else {
                channel.configureBlocking(false);
            }
            if (connected) {
                this.selectorManager.accept(channel, context);
            } else {
                this.selectorManager.connect(channel, context);
            }
        }
        catch (Throwable x) {
            if (x.getClass() == SocketException.class) {
                x = new SocketException("Could not connect to " + String.valueOf(address)).initCause(x);
            }
            IO.close(channel);
            this.connectFailed(channel, address, x, context);
        }
    }

    public void accept(SelectableChannel selectable, Map<String, Object> context) {
        try {
            SocketChannel channel = (SocketChannel)selectable;
            if (!channel.isConnected()) {
                throw new IllegalStateException("SocketChannel must be connected");
            }
            context.put(CONTEXT_KEY, this);
            this.configure(channel);
            channel.configureBlocking(false);
            this.selectorManager.accept(channel, context);
        }
        catch (Throwable failure) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Could not accept {}", (Object)selectable);
            }
            IO.close(selectable);
            this.acceptFailed(failure, selectable, context);
        }
    }

    private void bind(NetworkChannel channel, SocketAddress bindAddress) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Binding {} to {}", (Object)channel, (Object)bindAddress);
        }
        channel.bind(bindAddress);
    }

    protected void configure(SelectableChannel selectable) throws IOException {
        if (selectable instanceof NetworkChannel) {
            int sendBufferSize;
            NetworkChannel channel = (NetworkChannel)((Object)selectable);
            this.setSocketOption(channel, StandardSocketOptions.TCP_NODELAY, this.isTCPNoDelay());
            this.setSocketOption(channel, StandardSocketOptions.SO_REUSEADDR, this.getReuseAddress());
            this.setSocketOption(channel, StandardSocketOptions.SO_REUSEPORT, this.isReusePort());
            int receiveBufferSize = this.getReceiveBufferSize();
            if (receiveBufferSize >= 0) {
                this.setSocketOption(channel, StandardSocketOptions.SO_RCVBUF, receiveBufferSize);
            }
            if ((sendBufferSize = this.getSendBufferSize()) >= 0) {
                this.setSocketOption(channel, StandardSocketOptions.SO_SNDBUF, sendBufferSize);
            }
        }
    }

    private <T> void setSocketOption(NetworkChannel channel, SocketOption<T> option, T value) {
        block2: {
            try {
                channel.setOption(option, value);
            }
            catch (Throwable x) {
                if (!LOG.isTraceEnabled()) break block2;
                LOG.trace("Could not configure {} to {} on {}", option, value, channel, x);
            }
        }
    }

    protected EndPoint newEndPoint(SelectableChannel selectable, ManagedSelector selector, SelectionKey selectionKey) {
        Map context = (Map)selectionKey.attachment();
        Transport transport = (Transport)context.get(Transport.CONTEXT_KEY);
        return transport.newEndPoint(this.getScheduler(), selector, selectable, selectionKey);
    }

    protected Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        Transport transport = (Transport)context.get(Transport.CONTEXT_KEY);
        return transport.newConnection(endPoint, context);
    }

    protected void acceptFailed(Throwable failure, SelectableChannel channel, Map<String, Object> context) {
        Promise promise;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Could not accept {}", (Object)channel);
        }
        if ((promise = (Promise)context.get(CONNECTION_PROMISE_CONTEXT_KEY)) != null) {
            promise.failed(failure);
        }
    }

    protected void connectFailed(SelectableChannel channel, SocketAddress address, Throwable failure, Map<String, Object> context) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Could not connect to {}", (Object)address);
        }
        this.notifyConnectFailure((SocketChannel)channel, address, failure);
        Promise promise = (Promise)context.get(CONNECTION_PROMISE_CONTEXT_KEY);
        if (promise != null) {
            promise.failed(failure);
        }
    }

    @Override
    public boolean addEventListener(EventListener listener) {
        if (super.addEventListener(listener)) {
            if (listener instanceof ConnectListener) {
                ConnectListener connectListener = (ConnectListener)listener;
                this.listeners.add(connectListener);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeEventListener(EventListener listener) {
        if (super.removeEventListener(listener)) {
            if (listener instanceof ConnectListener) {
                ConnectListener connectListener = (ConnectListener)listener;
                this.listeners.remove(connectListener);
            }
            return true;
        }
        return false;
    }

    private void notifyConnectBegin(SocketChannel socketChannel, SocketAddress socketAddress) {
        for (ConnectListener listener : this.listeners) {
            try {
                listener.onConnectBegin(socketChannel, socketAddress);
            }
            catch (Throwable x) {
                LOG.info("failure notifying listener {}", (Object)listener, (Object)x);
            }
        }
    }

    private void notifyConnectSuccess(SocketChannel socketChannel) {
        for (ConnectListener listener : this.listeners) {
            try {
                listener.onConnectSuccess(socketChannel);
            }
            catch (Throwable x) {
                LOG.info("failure notifying listener {}", (Object)listener, (Object)x);
            }
        }
    }

    private void notifyConnectFailure(SocketChannel socketChannel, SocketAddress socketAddress, Throwable throwable) {
        for (ConnectListener listener : this.listeners) {
            try {
                listener.onConnectFailure(socketChannel, socketAddress, throwable);
            }
            catch (Throwable x) {
                LOG.info("failure notifying listener {}", (Object)listener, (Object)x);
            }
        }
    }

    protected class ClientSelectorManager
    extends SelectorManager {
        public ClientSelectorManager(Executor executor, Scheduler scheduler, int selectors) {
            super(executor, scheduler, selectors);
        }

        @Override
        protected EndPoint newEndPoint(SelectableChannel channel, ManagedSelector selector, SelectionKey selectionKey) {
            EndPoint endPoint = ClientConnector.this.newEndPoint(channel, selector, selectionKey);
            endPoint.setIdleTimeout(ClientConnector.this.getIdleTimeout().toMillis());
            return endPoint;
        }

        @Override
        public Connection newConnection(SelectableChannel channel, EndPoint endPoint, Object attachment) throws IOException {
            Map context = (Map)attachment;
            return ClientConnector.this.newConnection(endPoint, context);
        }

        @Override
        public void connectionOpened(Connection connection, Object context) {
            Map contextMap = (Map)context;
            Promise promise = (Promise)contextMap.get(CONNECTION_PROMISE_CONTEXT_KEY);
            try {
                super.connectionOpened(connection, context);
                promise.succeeded(connection);
            }
            catch (Throwable x) {
                promise.failed(x);
            }
        }

        @Override
        public void connectionSucceeded(SelectableChannel channel) {
            super.connectionSucceeded(channel);
            ClientConnector.this.notifyConnectSuccess((SocketChannel)channel);
        }

        @Override
        protected void connectionFailed(SelectableChannel channel, Throwable failure, Object attachment) {
            super.connectionFailed(channel, failure, attachment);
            Map context = (Map)attachment;
            SocketAddress address = (SocketAddress)context.get(REMOTE_SOCKET_ADDRESS_CONTEXT_KEY);
            ClientConnector.this.connectFailed(channel, address, failure, context);
        }
    }

    public static interface ConnectListener
    extends EventListener {
        default public void onConnectBegin(SocketChannel socketChannel, SocketAddress socketAddress) {
        }

        default public void onConnectSuccess(SocketChannel socketChannel) {
        }

        default public void onConnectFailure(SocketChannel socketChannel, SocketAddress socketAddress, Throwable failure) {
        }
    }
}

