/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import wiremock.org.eclipse.jetty.io.ByteBufferPool;
import wiremock.org.eclipse.jetty.io.Content;
import wiremock.org.eclipse.jetty.io.RetainableByteBuffer;
import wiremock.org.eclipse.jetty.util.Blocker;
import wiremock.org.eclipse.jetty.util.BufferUtil;
import wiremock.org.eclipse.jetty.util.TypeUtil;

@Deprecated
public class ByteBufferOutputStream2
extends OutputStream {
    private final RetainableByteBuffer.DynamicCapacity _accumulator;
    private int _size = 0;

    public ByteBufferOutputStream2() {
        this(null, false);
    }

    public ByteBufferOutputStream2(ByteBufferPool bufferPool, boolean direct) {
        this._accumulator = new RetainableByteBuffer.DynamicCapacity(bufferPool, direct, -1L);
    }

    public RetainableByteBuffer takeByteBuffer() {
        return this._accumulator.take();
    }

    public RetainableByteBuffer toByteBuffer() {
        return this._accumulator;
    }

    public byte[] toByteArray() {
        return BufferUtil.toArray(this._accumulator.getByteBuffer());
    }

    public int size() {
        return this._size;
    }

    @Override
    public void write(int b) {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this._size += len;
        this._accumulator.append(ByteBuffer.wrap(b, off, len));
    }

    public void write(ByteBuffer buffer) {
        this._size += buffer.remaining();
        this._accumulator.append(buffer);
    }

    public void writeTo(ByteBuffer buffer) {
        this._accumulator.putTo(buffer);
    }

    public void writeTo(OutputStream out) throws IOException {
        try (Blocker.Callback callback = Blocker.callback();){
            this._accumulator.writeTo(Content.Sink.from(out), false, callback);
            callback.block();
        }
    }

    @Override
    public void close() {
        this._accumulator.clear();
    }

    public synchronized String toString() {
        return String.format("%s@%x{size=%d, byteAccumulator=%s}", TypeUtil.toShortName(this.getClass()), this.hashCode(), this._size, this._accumulator);
    }
}

