/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.http2.parser;

import java.nio.ByteBuffer;
import wiremock.org.eclipse.jetty.http2.frames.PriorityFrame;
import wiremock.org.eclipse.jetty.io.ByteBufferPool;
import wiremock.org.eclipse.jetty.io.RetainableByteBuffer;
import wiremock.org.eclipse.jetty.util.BufferUtil;

public class HeaderBlockFragments {
    private final ByteBufferPool bufferPool;
    private final int maxCapacity;
    private PriorityFrame priorityFrame;
    private int streamId;
    private boolean endStream;
    private RetainableByteBuffer storage;

    public HeaderBlockFragments(ByteBufferPool bufferPool, int maxCapacity) {
        this.bufferPool = bufferPool;
        this.maxCapacity = maxCapacity;
    }

    void reset() {
        this.priorityFrame = null;
        this.streamId = 0;
        this.endStream = false;
        this.storage = null;
    }

    public boolean storeFragment(ByteBuffer fragment, int length, boolean last) {
        if (this.storage == null) {
            if (this.maxCapacity > 0 && length > this.maxCapacity) {
                return false;
            }
            int capacity = last ? length : length * 2;
            this.storage = this.bufferPool.acquire(capacity, fragment.isDirect());
            BufferUtil.flipToFill(this.storage.getByteBuffer());
        }
        if (this.storage.remaining() < length) {
            ByteBuffer byteBuffer = this.storage.getByteBuffer();
            if (this.maxCapacity > 0 && byteBuffer.position() + length > this.maxCapacity) {
                return false;
            }
            int space = last ? length : length * 2;
            int capacity = byteBuffer.position() + space;
            RetainableByteBuffer.Mutable newStorage = this.bufferPool.acquire(capacity, this.storage.isDirect());
            BufferUtil.flipToFill(newStorage.getByteBuffer());
            byteBuffer.flip();
            newStorage.getByteBuffer().put(byteBuffer);
            this.storage.release();
            this.storage = newStorage;
        }
        int limit = fragment.limit();
        fragment.limit(fragment.position() + length);
        this.storage.getByteBuffer().put(fragment);
        fragment.limit(limit);
        return true;
    }

    public PriorityFrame getPriorityFrame() {
        return this.priorityFrame;
    }

    public void setPriorityFrame(PriorityFrame priorityFrame) {
        this.priorityFrame = priorityFrame;
    }

    public boolean isEndStream() {
        return this.endStream;
    }

    public void setEndStream(boolean endStream) {
        this.endStream = endStream;
    }

    public RetainableByteBuffer complete() {
        this.storage.getByteBuffer().flip();
        return this.storage;
    }

    public int getStreamId() {
        return this.streamId;
    }

    public void setStreamId(int streamId) {
        this.streamId = streamId;
    }
}

