/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.http2.parser;

import java.nio.ByteBuffer;
import wiremock.org.eclipse.jetty.http.MetaData;
import wiremock.org.eclipse.jetty.http2.ErrorCode;
import wiremock.org.eclipse.jetty.http2.frames.ContinuationFrame;
import wiremock.org.eclipse.jetty.http2.frames.HeadersFrame;
import wiremock.org.eclipse.jetty.http2.hpack.HpackException;
import wiremock.org.eclipse.jetty.http2.parser.BodyParser;
import wiremock.org.eclipse.jetty.http2.parser.HeaderBlockFragments;
import wiremock.org.eclipse.jetty.http2.parser.HeaderBlockParser;
import wiremock.org.eclipse.jetty.http2.parser.HeaderParser;
import wiremock.org.eclipse.jetty.http2.parser.Parser;
import wiremock.org.eclipse.jetty.io.RetainableByteBuffer;

public class ContinuationBodyParser
extends BodyParser {
    private final HeaderBlockParser headerBlockParser;
    private final HeaderBlockFragments headerBlockFragments;
    private State state = State.PREPARE;
    private int length;

    public ContinuationBodyParser(HeaderParser headerParser, Parser.Listener listener, HeaderBlockParser headerBlockParser, HeaderBlockFragments headerBlockFragments) {
        super(headerParser, listener);
        this.headerBlockParser = headerBlockParser;
        this.headerBlockFragments = headerBlockFragments;
    }

    @Override
    protected void emptyBody(ByteBuffer buffer) {
        if (this.hasFlag(4)) {
            this.onHeaders(buffer);
        } else {
            ContinuationFrame frame = new ContinuationFrame(this.getStreamId(), this.hasFlag(4));
            if (!this.rateControlOnEvent(frame)) {
                this.connectionFailure(buffer, ErrorCode.ENHANCE_YOUR_CALM_ERROR.code, "invalid_continuation_frame_rate");
            }
        }
    }

    @Override
    public boolean parse(ByteBuffer buffer) {
        block4: while (buffer.hasRemaining()) {
            switch (this.state.ordinal()) {
                case 0: {
                    if (this.getStreamId() == 0) {
                        return this.connectionFailure(buffer, ErrorCode.PROTOCOL_ERROR.code, "invalid_continuation_frame");
                    }
                    if (this.getStreamId() != this.headerBlockFragments.getStreamId()) {
                        return this.connectionFailure(buffer, ErrorCode.PROTOCOL_ERROR.code, "invalid_continuation_stream");
                    }
                    this.length = this.getBodyLength();
                    this.state = State.FRAGMENT;
                    continue block4;
                }
                case 1: {
                    int remaining = buffer.remaining();
                    if (remaining < this.length) {
                        ContinuationFrame frame = new ContinuationFrame(this.getStreamId(), false);
                        if (!this.rateControlOnEvent(frame)) {
                            return this.connectionFailure(buffer, ErrorCode.ENHANCE_YOUR_CALM_ERROR.code, "invalid_continuation_frame_rate");
                        }
                        if (!this.headerBlockFragments.storeFragment(buffer, remaining, false)) {
                            return this.connectionFailure(buffer, ErrorCode.PROTOCOL_ERROR.code, "invalid_continuation_stream");
                        }
                        this.length -= remaining;
                        continue block4;
                    }
                    boolean endHeaders = this.hasFlag(4);
                    ContinuationFrame frame = new ContinuationFrame(this.getStreamId(), endHeaders);
                    if (!this.rateControlOnEvent(frame)) {
                        return this.connectionFailure(buffer, ErrorCode.ENHANCE_YOUR_CALM_ERROR.code, "invalid_continuation_frame_rate");
                    }
                    if (!this.headerBlockFragments.storeFragment(buffer, this.length, endHeaders)) {
                        return this.connectionFailure(buffer, ErrorCode.PROTOCOL_ERROR.code, "invalid_continuation_stream");
                    }
                    this.reset();
                    if (endHeaders) {
                        return this.onHeaders(buffer);
                    }
                    return true;
                }
            }
            throw new IllegalStateException();
        }
        return false;
    }

    private boolean onHeaders(ByteBuffer buffer) {
        RetainableByteBuffer headerBlock = this.headerBlockFragments.complete();
        MetaData metaData = this.headerBlockParser.parse(headerBlock.getByteBuffer(), headerBlock.remaining());
        headerBlock.release();
        HeadersFrame frame = new HeadersFrame(this.getStreamId(), metaData, this.headerBlockFragments.getPriorityFrame(), this.headerBlockFragments.isEndStream());
        this.headerBlockFragments.reset();
        Throwable metaDataFailure = MetaData.Failed.getFailure(metaData);
        if (metaDataFailure instanceof HpackException.SessionException) {
            return false;
        }
        if (metaDataFailure != null && !this.rateControlOnEvent(frame)) {
            return this.connectionFailure(buffer, ErrorCode.ENHANCE_YOUR_CALM_ERROR.code, "invalid_headers_frame_rate");
        }
        this.notifyHeaders(frame);
        return true;
    }

    private void reset() {
        this.state = State.PREPARE;
        this.length = 0;
    }

    private static enum State {
        PREPARE,
        FRAGMENT;

    }
}

