/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.http2.hpack.internal;

import wiremock.org.eclipse.jetty.http.HostPortHttpField;
import wiremock.org.eclipse.jetty.http.HttpField;
import wiremock.org.eclipse.jetty.http.HttpFields;
import wiremock.org.eclipse.jetty.http.HttpHeader;
import wiremock.org.eclipse.jetty.http.HttpMethod;
import wiremock.org.eclipse.jetty.http.HttpScheme;
import wiremock.org.eclipse.jetty.http.HttpURI;
import wiremock.org.eclipse.jetty.http.HttpVersion;
import wiremock.org.eclipse.jetty.http.MetaData;
import wiremock.org.eclipse.jetty.http2.hpack.HpackException;
import wiremock.org.eclipse.jetty.http2.hpack.internal.AuthorityHttpField;
import wiremock.org.eclipse.jetty.http2.hpack.internal.StaticTableHttpField;
import wiremock.org.eclipse.jetty.util.NanoTime;

public class MetaDataBuilder {
    private final HttpFields.Mutable _fields = HttpFields.build();
    private int _maxSize;
    private int _size;
    private Integer _status;
    private String _method;
    private HttpScheme _scheme;
    private HostPortHttpField _authority;
    private String _path;
    private String _protocol;
    private long _contentLength = -1L;
    private HpackException.StreamException _streamException;
    private boolean _request;
    private boolean _response;
    private long _beginNanoTime = Long.MIN_VALUE;

    public MetaDataBuilder(int maxHeadersSize) {
        this._maxSize = maxHeadersSize;
    }

    private void reset() {
        this._fields.clear();
        this._size = 0;
        this._status = null;
        this._method = null;
        this._scheme = null;
        this._authority = null;
        this._path = null;
        this._protocol = null;
        this._contentLength = -1L;
        this._streamException = null;
        this._request = false;
        this._response = false;
        this._beginNanoTime = Long.MIN_VALUE;
    }

    public int getMaxSize() {
        return this._maxSize;
    }

    public void setMaxSize(int maxSize) {
        this._maxSize = maxSize;
    }

    public void setBeginNanoTime(long beginNanoTime) {
        if (beginNanoTime == Long.MIN_VALUE) {
            ++beginNanoTime;
        }
        this._beginNanoTime = beginNanoTime;
    }

    public int getSize() {
        return this._size;
    }

    public void emit(HttpField field) throws HpackException.SessionException {
        block41: {
            String value;
            String name;
            HttpHeader header;
            block40: {
                header = field.getHeader();
                name = field.getName();
                if (name == null || name.isEmpty()) {
                    throw new HpackException.SessionException("Header size 0", new Object[0]);
                }
                value = field.getValue();
                int fieldSize = name.length() + (value == null ? 0 : value.length());
                this._size += fieldSize + 32;
                int maxSize = this.getMaxSize();
                if (maxSize > 0 && this._size > maxSize) {
                    throw new HpackException.SessionException("Header size %d > %d", this._size, maxSize);
                }
                if (!(field instanceof StaticTableHttpField)) break block40;
                StaticTableHttpField staticField = (StaticTableHttpField)field;
                switch (header) {
                    case C_STATUS: {
                        if (this.checkPseudoHeader(header, this._status)) {
                            this._status = staticField.getIntValue();
                        }
                        this._response = true;
                        break block41;
                    }
                    case C_METHOD: {
                        if (this.checkPseudoHeader(header, this._method)) {
                            this._method = value;
                        }
                        this._request = true;
                        break block41;
                    }
                    case C_SCHEME: {
                        if (this.checkPseudoHeader(header, (Object)this._scheme)) {
                            this._scheme = (HttpScheme)((Object)staticField.getStaticValue());
                        }
                        this._request = true;
                        break block41;
                    }
                    default: {
                        throw new IllegalArgumentException(name);
                    }
                }
            }
            if (header != null) {
                switch (header) {
                    case C_STATUS: {
                        if (this.checkPseudoHeader(header, this._status)) {
                            this._status = field.getIntValue();
                        }
                        this._response = true;
                        break;
                    }
                    case C_METHOD: {
                        if (this.checkPseudoHeader(header, this._method)) {
                            this._method = value;
                        }
                        this._request = true;
                        break;
                    }
                    case C_SCHEME: {
                        if (this.checkPseudoHeader(header, (Object)this._scheme) && value != null) {
                            this._scheme = HttpScheme.CACHE.get(value);
                        }
                        this._request = true;
                        break;
                    }
                    case C_AUTHORITY: {
                        if (this.checkPseudoHeader(header, this._authority)) {
                            if (field instanceof HostPortHttpField) {
                                this._authority = (HostPortHttpField)field;
                            } else if (value != null) {
                                this._authority = new AuthorityHttpField(value);
                            }
                        }
                        this._request = true;
                        break;
                    }
                    case C_PATH: {
                        if (this.checkPseudoHeader(header, this._path)) {
                            if (value != null && !value.isEmpty()) {
                                this._path = value;
                            } else {
                                this.streamException("No Path", new Object[0]);
                            }
                        }
                        this._request = true;
                        break;
                    }
                    case C_PROTOCOL: {
                        if (this.checkPseudoHeader(header, this._protocol)) {
                            this._protocol = value;
                        }
                        this._request = true;
                        break;
                    }
                    case HOST: {
                        this._fields.add(field);
                        break;
                    }
                    case CONTENT_LENGTH: {
                        this._contentLength = field.getLongValue();
                        this._fields.add(field);
                        break;
                    }
                    case TE: {
                        if ("trailers".equalsIgnoreCase(value)) {
                            this._fields.add(field);
                            break;
                        }
                        this.streamException("Unsupported TE value '%s'", value);
                        break;
                    }
                    case CONNECTION: {
                        if ("TE".equalsIgnoreCase(value)) {
                            this._fields.add(field);
                            break;
                        }
                        this.streamException("Connection specific field '%s'", new Object[]{header});
                        break;
                    }
                    default: {
                        if (name.charAt(0) == ':') {
                            this.streamException("Unknown pseudo header '%s'", name);
                            break;
                        }
                        this._fields.add(field);
                        break;
                    }
                }
            } else if (name.charAt(0) == ':') {
                this.streamException("Unknown pseudo header '%s'", name);
            } else {
                this._fields.add(field);
            }
        }
    }

    public void streamException(String messageFormat, Object ... args) {
        HpackException.StreamException stream = new HpackException.StreamException(this._request, this._response, messageFormat, args);
        if (this._streamException == null) {
            this._streamException = stream;
        } else {
            this._streamException.addSuppressed(stream);
        }
    }

    protected boolean checkPseudoHeader(HttpHeader header, Object value) {
        if (this._fields.size() > 0) {
            this.streamException("Pseudo header %s after fields", header.asString());
            return false;
        }
        if (value == null) {
            return true;
        }
        this.streamException("Duplicate pseudo header %s", header.asString());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaData build() throws HpackException.StreamException {
        try {
            if (this._streamException != null) {
                throw this._streamException;
            }
            if (this._request && this._response) {
                throw new HpackException.StreamException(true, true, "Request and Response headers", new Object[0]);
            }
            if (this._request) {
                if (this._method == null) {
                    throw new HpackException.StreamException(true, false, "No Method", new Object[0]);
                }
                boolean isConnect = HttpMethod.CONNECT.is(this._method);
                if (!isConnect || this._protocol != null) {
                    if (this._scheme == null) {
                        throw new HpackException.StreamException(true, false, "No Scheme", new Object[0]);
                    }
                    if (this._path == null) {
                        throw new HpackException.StreamException(true, false, "No Path", new Object[0]);
                    }
                }
                long nanoTime = this._beginNanoTime == Long.MIN_VALUE ? NanoTime.now() : this._beginNanoTime;
                this._beginNanoTime = Long.MIN_VALUE;
                if (isConnect) {
                    MetaData.ConnectRequest connectRequest = new MetaData.ConnectRequest(nanoTime, this._scheme, this._authority, this._path, (HttpFields)this._fields, this._protocol);
                    return connectRequest;
                }
                MetaData.Request request = new MetaData.Request(nanoTime, this._method, this.newHttpURI(), HttpVersion.HTTP_2, this._fields, this._contentLength, null);
                return request;
            }
            if (this._response) {
                if (this._status == null) {
                    throw new HpackException.StreamException(false, true, "No Status", new Object[0]);
                }
                MetaData.Response response = new MetaData.Response(this._status, null, HttpVersion.HTTP_2, this._fields, this._contentLength);
                return response;
            }
            MetaData metaData = new MetaData(HttpVersion.HTTP_2, this._fields, this._contentLength);
            return metaData;
        }
        finally {
            this.reset();
        }
    }

    private HttpURI newHttpURI() throws HpackException.StreamException {
        try {
            return HttpURI.build().scheme(this._scheme).host(this._authority == null ? null : this._authority.getHost()).port(this._authority == null ? -1 : this._authority.getPort()).pathQuery(this._path);
        }
        catch (Throwable x) {
            throw new HpackException.StreamException(x, true, false, "Invalid URI", new Object[0]);
        }
    }
}

