/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.http2.hpack;

public abstract class HpackException
extends Exception {
    HpackException(String messageFormat, Object ... args) {
        super(String.format(messageFormat, args));
    }

    HpackException(Throwable cause, String messageFormat, Object ... args) {
        super(String.format(messageFormat, args), cause);
    }

    public static class CompressionException
    extends SessionException {
        public CompressionException(String messageFormat, Object ... args) {
            super(messageFormat, args);
        }
    }

    public static class SessionException
    extends HpackException {
        public SessionException(String messageFormat, Object ... args) {
            super(messageFormat, args);
        }
    }

    public static class StreamException
    extends HpackException {
        private final boolean request;
        private final boolean response;

        public StreamException(boolean request, boolean response, String messageFormat, Object ... args) {
            super(messageFormat, args);
            this.request = request;
            this.response = response;
        }

        public StreamException(Throwable cause, boolean request, boolean response, String messageFormat, Object ... args) {
            super(cause, messageFormat, args);
            this.request = request;
            this.response = response;
        }

        public boolean isRequest() {
            return this.request;
        }

        public boolean isResponse() {
            return this.response;
        }
    }
}

