/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.http2.generator;

import wiremock.org.eclipse.jetty.http2.frames.Frame;
import wiremock.org.eclipse.jetty.http2.frames.FrameType;
import wiremock.org.eclipse.jetty.http2.frames.WindowUpdateFrame;
import wiremock.org.eclipse.jetty.http2.generator.FrameGenerator;
import wiremock.org.eclipse.jetty.http2.generator.HeaderGenerator;
import wiremock.org.eclipse.jetty.io.RetainableByteBuffer;

public class WindowUpdateGenerator
extends FrameGenerator {
    public WindowUpdateGenerator(HeaderGenerator headerGenerator) {
        super(headerGenerator);
    }

    @Override
    public int generate(RetainableByteBuffer.Mutable accumulator, Frame frame) {
        WindowUpdateFrame windowUpdateFrame = (WindowUpdateFrame)frame;
        return this.generateWindowUpdate(accumulator, windowUpdateFrame.getStreamId(), windowUpdateFrame.getWindowDelta());
    }

    public int generateWindowUpdate(RetainableByteBuffer.Mutable accumulator, int streamId, int windowUpdate) {
        if (windowUpdate < 0) {
            throw new IllegalArgumentException("Invalid window update: " + windowUpdate);
        }
        this.generateHeader(accumulator, FrameType.WINDOW_UPDATE, 4, 0, streamId);
        accumulator.putInt(windowUpdate);
        return 13;
    }
}

