/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.http2.generator;

import java.util.Map;
import wiremock.org.eclipse.jetty.http2.frames.Frame;
import wiremock.org.eclipse.jetty.http2.frames.FrameType;
import wiremock.org.eclipse.jetty.http2.frames.SettingsFrame;
import wiremock.org.eclipse.jetty.http2.generator.FrameGenerator;
import wiremock.org.eclipse.jetty.http2.generator.HeaderGenerator;
import wiremock.org.eclipse.jetty.io.RetainableByteBuffer;

public class SettingsGenerator
extends FrameGenerator {
    public SettingsGenerator(HeaderGenerator headerGenerator) {
        super(headerGenerator);
    }

    @Override
    public int generate(RetainableByteBuffer.Mutable accumulator, Frame frame) {
        SettingsFrame settingsFrame = (SettingsFrame)frame;
        return this.generateSettings(accumulator, settingsFrame.getSettings(), settingsFrame.isReply());
    }

    public int generateSettings(RetainableByteBuffer.Mutable accumulator, Map<Integer, Integer> settings, boolean reply) {
        int entryLength = 6;
        int length = entryLength * settings.size();
        if (length > this.getMaxFrameSize()) {
            throw new IllegalArgumentException("Invalid settings, too big");
        }
        this.generateHeader(accumulator, FrameType.SETTINGS, length, reply ? 1 : 0, 0);
        for (Map.Entry<Integer, Integer> entry : settings.entrySet()) {
            accumulator.putShort(entry.getKey().shortValue());
            accumulator.putInt(entry.getValue());
        }
        return 9 + length;
    }
}

