/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.http2.generator;

import wiremock.org.eclipse.jetty.http2.frames.Frame;
import wiremock.org.eclipse.jetty.http2.frames.FrameType;
import wiremock.org.eclipse.jetty.http2.frames.PingFrame;
import wiremock.org.eclipse.jetty.http2.generator.FrameGenerator;
import wiremock.org.eclipse.jetty.http2.generator.HeaderGenerator;
import wiremock.org.eclipse.jetty.io.RetainableByteBuffer;

public class PingGenerator
extends FrameGenerator {
    public PingGenerator(HeaderGenerator headerGenerator) {
        super(headerGenerator);
    }

    @Override
    public int generate(RetainableByteBuffer.Mutable accumulator, Frame frame) {
        PingFrame pingFrame = (PingFrame)frame;
        return this.generatePing(accumulator, pingFrame.getPayload(), pingFrame.isReply());
    }

    public int generatePing(RetainableByteBuffer.Mutable accumulator, byte[] payload, boolean reply) {
        if (payload.length != 8) {
            throw new IllegalArgumentException("Invalid payload length: " + payload.length);
        }
        this.generateHeader(accumulator, FrameType.PING, 8, reply ? 1 : 0, 0);
        accumulator.put(payload, 0, payload.length);
        return 17;
    }
}

