/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.http2.generator;

import wiremock.org.eclipse.jetty.http2.frames.Frame;
import wiremock.org.eclipse.jetty.http2.frames.FrameType;
import wiremock.org.eclipse.jetty.http2.frames.GoAwayFrame;
import wiremock.org.eclipse.jetty.http2.generator.FrameGenerator;
import wiremock.org.eclipse.jetty.http2.generator.HeaderGenerator;
import wiremock.org.eclipse.jetty.io.RetainableByteBuffer;

public class GoAwayGenerator
extends FrameGenerator {
    public GoAwayGenerator(HeaderGenerator headerGenerator) {
        super(headerGenerator);
    }

    @Override
    public int generate(RetainableByteBuffer.Mutable accumulator, Frame frame) {
        GoAwayFrame goAwayFrame = (GoAwayFrame)frame;
        return this.generateGoAway(accumulator, goAwayFrame.getLastStreamId(), goAwayFrame.getError(), goAwayFrame.getPayload());
    }

    public int generateGoAway(RetainableByteBuffer.Mutable accumulator, int lastStreamId, int error, byte[] payload) {
        if (lastStreamId < 0) {
            lastStreamId = 0;
        }
        int fixedLength = 8;
        int maxPayloadLength = 16384 - fixedLength;
        int payloadLength = Math.min(payload == null ? 0 : payload.length, maxPayloadLength);
        int length = fixedLength + payloadLength;
        this.generateHeader(accumulator, FrameType.GO_AWAY, length, 0, 0);
        accumulator.putInt(lastStreamId);
        accumulator.putInt(error);
        if (payload != null) {
            accumulator.put(payload, 0, payloadLength);
        }
        return 9 + length;
    }
}

