/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.http2.generator;

import wiremock.org.eclipse.jetty.http2.frames.DataFrame;
import wiremock.org.eclipse.jetty.http2.frames.Frame;
import wiremock.org.eclipse.jetty.http2.frames.FrameType;
import wiremock.org.eclipse.jetty.http2.generator.DataGenerator;
import wiremock.org.eclipse.jetty.http2.generator.FrameGenerator;
import wiremock.org.eclipse.jetty.http2.generator.GoAwayGenerator;
import wiremock.org.eclipse.jetty.http2.generator.HeaderGenerator;
import wiremock.org.eclipse.jetty.http2.generator.HeadersGenerator;
import wiremock.org.eclipse.jetty.http2.generator.PingGenerator;
import wiremock.org.eclipse.jetty.http2.generator.PrefaceGenerator;
import wiremock.org.eclipse.jetty.http2.generator.PriorityGenerator;
import wiremock.org.eclipse.jetty.http2.generator.PushPromiseGenerator;
import wiremock.org.eclipse.jetty.http2.generator.ResetGenerator;
import wiremock.org.eclipse.jetty.http2.generator.SettingsGenerator;
import wiremock.org.eclipse.jetty.http2.generator.WindowUpdateGenerator;
import wiremock.org.eclipse.jetty.http2.hpack.HpackEncoder;
import wiremock.org.eclipse.jetty.http2.hpack.HpackException;
import wiremock.org.eclipse.jetty.io.ByteBufferPool;
import wiremock.org.eclipse.jetty.io.RetainableByteBuffer;

public class Generator {
    private final ByteBufferPool bufferPool;
    private final HeaderGenerator headerGenerator;
    private final HpackEncoder hpackEncoder;
    private final FrameGenerator[] generators;
    private final PrefaceGenerator prefaceGenerator;
    private final DataGenerator dataGenerator;

    public Generator(ByteBufferPool bufferPool) {
        this(bufferPool, 0);
    }

    public Generator(ByteBufferPool bufferPool, int maxHeaderBlockFragment) {
        this(bufferPool, true, maxHeaderBlockFragment);
    }

    public Generator(ByteBufferPool bufferPool, boolean useDirectByteBuffers, int maxHeaderBlockFragment) {
        this.bufferPool = bufferPool;
        this.headerGenerator = new HeaderGenerator(bufferPool, useDirectByteBuffers);
        this.hpackEncoder = new HpackEncoder();
        this.generators = new FrameGenerator[FrameType.CONTINUATION.ordinal() + 1];
        this.generators[FrameType.HEADERS.getType()] = new HeadersGenerator(this.headerGenerator, this.hpackEncoder, maxHeaderBlockFragment);
        this.generators[FrameType.PRIORITY.getType()] = new PriorityGenerator(this.headerGenerator);
        this.generators[FrameType.RST_STREAM.getType()] = new ResetGenerator(this.headerGenerator);
        this.generators[FrameType.SETTINGS.getType()] = new SettingsGenerator(this.headerGenerator);
        this.generators[FrameType.PUSH_PROMISE.getType()] = new PushPromiseGenerator(this.headerGenerator, this.hpackEncoder);
        this.generators[FrameType.PING.getType()] = new PingGenerator(this.headerGenerator);
        this.generators[FrameType.GO_AWAY.getType()] = new GoAwayGenerator(this.headerGenerator);
        this.generators[FrameType.WINDOW_UPDATE.getType()] = new WindowUpdateGenerator(this.headerGenerator);
        this.generators[FrameType.CONTINUATION.getType()] = null;
        this.prefaceGenerator = new PrefaceGenerator();
        this.dataGenerator = new DataGenerator(this.headerGenerator);
    }

    public ByteBufferPool getByteBufferPool() {
        return this.bufferPool;
    }

    public HpackEncoder getHpackEncoder() {
        return this.hpackEncoder;
    }

    public int getMaxFrameSize() {
        return this.headerGenerator.getMaxFrameSize();
    }

    public void setMaxFrameSize(int maxFrameSize) {
        this.headerGenerator.setMaxFrameSize(maxFrameSize);
    }

    public int control(RetainableByteBuffer.Mutable accumulator, Frame frame) throws HpackException {
        int type = frame.getType().getType();
        if (type == FrameType.PREFACE.getType()) {
            return this.prefaceGenerator.generate(accumulator, frame);
        }
        return this.generators[type].generate(accumulator, frame);
    }

    public int data(RetainableByteBuffer.Mutable accumulator, DataFrame frame, int maxLength) {
        return this.dataGenerator.generate(accumulator, frame, maxLength);
    }
}

