/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.http2.generator;

import java.nio.ByteBuffer;
import wiremock.org.eclipse.jetty.http.MetaData;
import wiremock.org.eclipse.jetty.http2.frames.Frame;
import wiremock.org.eclipse.jetty.http2.frames.FrameType;
import wiremock.org.eclipse.jetty.http2.generator.HeaderGenerator;
import wiremock.org.eclipse.jetty.http2.hpack.HpackEncoder;
import wiremock.org.eclipse.jetty.http2.hpack.HpackException;
import wiremock.org.eclipse.jetty.io.RetainableByteBuffer;
import wiremock.org.eclipse.jetty.util.BufferUtil;

public abstract class FrameGenerator {
    private final HeaderGenerator headerGenerator;

    protected FrameGenerator(HeaderGenerator headerGenerator) {
        this.headerGenerator = headerGenerator;
    }

    public abstract int generate(RetainableByteBuffer.Mutable var1, Frame var2) throws HpackException;

    protected void generateHeader(RetainableByteBuffer.Mutable accumulator, FrameType frameType, int length, int flags, int streamId) {
        this.headerGenerator.generate(accumulator, frameType, 9 + length, length, flags, streamId);
    }

    public int getMaxFrameSize() {
        return this.headerGenerator.getMaxFrameSize();
    }

    public boolean isUseDirectByteBuffers() {
        return this.headerGenerator.isUseDirectByteBuffers();
    }

    protected RetainableByteBuffer encode(HpackEncoder encoder, MetaData metaData) throws HpackException {
        int bufferSize = encoder.getMaxHeaderListSize();
        if (bufferSize <= 0) {
            bufferSize = 4096;
        }
        RetainableByteBuffer.Mutable hpacked = this.headerGenerator.getByteBufferPool().acquire(bufferSize, this.isUseDirectByteBuffers());
        try {
            ByteBuffer byteBuffer = hpacked.getByteBuffer();
            BufferUtil.clearToFill(byteBuffer);
            encoder.encode(byteBuffer, metaData);
            return hpacked;
        }
        catch (HpackException x) {
            hpacked.release();
            throw x;
        }
    }
}

