/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.http2.api;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import wiremock.org.eclipse.jetty.http2.api.Stream;
import wiremock.org.eclipse.jetty.http2.frames.GoAwayFrame;
import wiremock.org.eclipse.jetty.http2.frames.HeadersFrame;
import wiremock.org.eclipse.jetty.http2.frames.PingFrame;
import wiremock.org.eclipse.jetty.http2.frames.PriorityFrame;
import wiremock.org.eclipse.jetty.http2.frames.ResetFrame;
import wiremock.org.eclipse.jetty.http2.frames.SettingsFrame;
import wiremock.org.eclipse.jetty.util.Callback;
import wiremock.org.eclipse.jetty.util.Promise;

public interface Session {
    default public CompletableFuture<Stream> newStream(HeadersFrame frame, Stream.Listener listener) {
        return Promise.Completable.with(p -> this.newStream(frame, (Promise<Stream>)p, listener));
    }

    public void newStream(HeadersFrame var1, Promise<Stream> var2, Stream.Listener var3);

    public int priority(PriorityFrame var1, Callback var2);

    default public CompletableFuture<Void> settings(SettingsFrame frame) {
        return Callback.Completable.with(c -> this.settings(frame, (Callback)c));
    }

    public void settings(SettingsFrame var1, Callback var2);

    public void ping(PingFrame var1, Callback var2);

    public boolean close(int var1, String var2, Callback var3);

    public boolean isClosed();

    public boolean isPushEnabled();

    public Collection<Stream> getStreams();

    public Stream getStream(int var1);

    @Deprecated
    public InetSocketAddress getLocalAddress();

    default public SocketAddress getLocalSocketAddress() {
        return this.getLocalAddress();
    }

    @Deprecated
    public InetSocketAddress getRemoteAddress();

    default public SocketAddress getRemoteSocketAddress() {
        return this.getRemoteAddress();
    }

    public CompletableFuture<Void> shutdown();

    public static interface Listener {
        default public Map<Integer, Integer> onPreface(Session session) {
            return null;
        }

        default public Stream.Listener onNewStream(Stream stream, HeadersFrame frame) {
            if (!frame.isEndStream()) {
                stream.demand();
            }
            return Stream.Listener.AUTO_DISCARD;
        }

        default public void onSettings(Session session, SettingsFrame frame) {
        }

        default public void onPing(Session session, PingFrame frame) {
        }

        default public void onReset(Session session, ResetFrame frame) {
        }

        default public void onGoAway(Session session, GoAwayFrame frame) {
        }

        default public void onClose(Session session, GoAwayFrame frame, Callback callback) {
            callback.succeeded();
        }

        default public boolean onIdleTimeout(Session session) {
            return true;
        }

        default public void onFailure(Session session, Throwable failure, Callback callback) {
            callback.succeeded();
        }
    }
}

