/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.http2;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadPendingException;
import java.nio.channels.WritePendingException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import wiremock.org.eclipse.jetty.http2.ErrorCode;
import wiremock.org.eclipse.jetty.http2.HTTP2Stream;
import wiremock.org.eclipse.jetty.http2.api.Stream;
import wiremock.org.eclipse.jetty.http2.frames.DataFrame;
import wiremock.org.eclipse.jetty.http2.frames.ResetFrame;
import wiremock.org.eclipse.jetty.io.Connection;
import wiremock.org.eclipse.jetty.io.EndPoint;
import wiremock.org.eclipse.jetty.io.EofException;
import wiremock.org.eclipse.jetty.util.BufferUtil;
import wiremock.org.eclipse.jetty.util.Callback;
import wiremock.org.eclipse.jetty.util.ExceptionUtil;
import wiremock.org.eclipse.jetty.util.IO;
import wiremock.org.eclipse.jetty.util.TypeUtil;
import wiremock.org.eclipse.jetty.util.thread.Invocable;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public abstract class HTTP2StreamEndPoint
implements EndPoint,
Invocable {
    private static final Logger LOG = LoggerFactory.getLogger(HTTP2StreamEndPoint.class);
    private final AtomicReference<WriteState> writeState = new AtomicReference<WriteState>(WriteState.IDLE);
    private final AtomicReference<Callback> readCallback = new AtomicReference();
    private final long created = System.currentTimeMillis();
    private final HTTP2Stream stream;
    private final AtomicBoolean eof = new AtomicBoolean();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicReference<Throwable> failure = new AtomicReference();
    private final AtomicReference<Stream.Data> data = new AtomicReference();
    private Connection connection;

    public HTTP2StreamEndPoint(HTTP2Stream stream) {
        this.stream = stream;
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.stream.getSession().getLocalSocketAddress();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.stream.getSession().getRemoteSocketAddress();
    }

    @Override
    public boolean isOpen() {
        return !this.closed.get();
    }

    @Override
    public long getCreatedTimeStamp() {
        return this.created;
    }

    @Override
    public void shutdownOutput() {
        block5: while (true) {
            WriteState current = this.writeState.get();
            switch (current.state.ordinal()) {
                case 0: {
                    if (!this.writeState.compareAndSet(current, WriteState.OSHUT)) continue block5;
                    Callback oshutCallback = Callback.from(Invocable.InvocationType.NON_BLOCKING, this::oshutSuccess, this::oshutFailure);
                    this.stream.data(new DataFrame(this.stream.getId(), BufferUtil.EMPTY_BUFFER, true), oshutCallback);
                    return;
                }
                case 1: {
                    Callback callback = ((WriteState.Pending)current).callback;
                    if (!this.writeState.compareAndSet(current, new WriteState.Pending(WriteState.State.PENDING_OSHUT, this, callback))) continue block5;
                    return;
                }
                case 2: 
                case 3: 
                case 4: {
                    return;
                }
            }
        }
    }

    private void oshutSuccess() {
        WriteState current = this.writeState.get();
        switch (current.state.ordinal()) {
            case 0: 
            case 1: 
            case 2: {
                throw new IllegalStateException();
            }
        }
    }

    private void oshutFailure(Throwable failure) {
        WriteState current;
        do {
            current = this.writeState.get();
            if (current.state == WriteState.State.OSHUT) continue;
            return;
        } while (!this.writeState.compareAndSet(current, new WriteState(WriteState.State.FAILED, failure)));
    }

    @Override
    public boolean isOutputShutdown() {
        WriteState.State state = this.writeState.get().state;
        return state == WriteState.State.PENDING_OSHUT || state == WriteState.State.OSHUT || state == WriteState.State.FAILED;
    }

    @Override
    public boolean isInputShutdown() {
        return this.eof.get();
    }

    @Override
    public void close(Throwable cause) {
        if (this.closed.compareAndSet(false, true)) {
            Stream.Data data;
            if (LOG.isDebugEnabled()) {
                LOG.atDebug().setCause(cause).log("closing {}", (Object)this);
            }
            if ((data = (Stream.Data)this.data.getAndSet(null)) != null) {
                data.release();
            }
            this.shutdownOutput();
            this.stream.close();
            this.connection.onClose(cause);
            this.onClose(cause);
        }
    }

    @Override
    public int fill(ByteBuffer sink) throws IOException {
        Stream.Data data = this.data.get();
        if (data != null) {
            return this.fillFromData(data, sink);
        }
        Throwable failure = this.failure.get();
        if (failure != null) {
            throw IO.rethrow(failure);
        }
        if (this.eof.get()) {
            return -1;
        }
        data = this.stream.readData();
        this.data.set(data);
        if (LOG.isDebugEnabled()) {
            LOG.debug("filled {} on {}", (Object)data, (Object)this);
        }
        if (data == null) {
            return 0;
        }
        return this.fillFromData(data, sink);
    }

    private int fillFromData(Stream.Data data, ByteBuffer sink) {
        int length = 0;
        ByteBuffer source = data.frame().getByteBuffer();
        boolean hasContent = source.hasRemaining();
        if (hasContent) {
            int sinkPosition = BufferUtil.flipToFill(sink);
            int sourceLength = source.remaining();
            length = Math.min(sourceLength, sink.remaining());
            int sourceLimit = source.limit();
            source.limit(source.position() + length);
            sink.put(source);
            source.limit(sourceLimit);
            BufferUtil.flipToFlush(sink, sinkPosition);
        }
        if (!source.hasRemaining()) {
            boolean endStream = data.frame().isEndStream();
            this.eof.set(endStream);
            data.release();
            this.data.set(null);
            if (!endStream) {
                this.stream.demand();
            }
            if (!hasContent) {
                length = endStream ? -1 : 0;
            }
        }
        return length;
    }

    @Override
    public boolean flush(ByteBuffer ... buffers) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("flushing {} on {}", (Object)BufferUtil.toDetailString(buffers), (Object)this);
        }
        if (buffers == null || buffers.length == 0 || this.remaining(buffers) == 0L) {
            return true;
        }
        WriteState current = this.writeState.get();
        switch (current.state.ordinal()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 0: 
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                throw new EofException("Output shutdown");
            }
            case 4: {
                throw IO.rethrow(current.failure);
            }
        }
        return false;
    }

    @Override
    public Object getTransport() {
        return this.stream;
    }

    @Override
    public long getIdleTimeout() {
        return this.stream.getIdleTimeout();
    }

    @Override
    public void setIdleTimeout(long idleTimeout) {
        this.stream.setIdleTimeout(idleTimeout);
    }

    @Override
    public void fillInterested(Callback callback) throws ReadPendingException {
        if (!this.tryFillInterested(callback)) {
            throw new ReadPendingException();
        }
    }

    @Override
    public boolean tryFillInterested(Callback callback) {
        boolean result = this.readCallback.compareAndSet(null, callback);
        if (result) {
            if (this.data.get() != null) {
                this.process();
            } else {
                this.stream.demand();
            }
        }
        return result;
    }

    @Override
    public boolean isFillInterested() {
        return this.readCallback.get() != null;
    }

    @Override
    public void write(Callback callback, ByteBuffer ... buffers) throws WritePendingException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("writing {} on {}", (Object)BufferUtil.toDetailString(buffers), (Object)this);
        }
        if (buffers != null && buffers.length != 0 && this.remaining(buffers) != 0L) {
            block6: while (true) {
                WriteState current = this.writeState.get();
                switch (current.state.ordinal()) {
                    case 0: {
                        WriteState.Pending pending = new WriteState.Pending(WriteState.State.PENDING, this, callback);
                        if (!this.writeState.compareAndSet(current, pending)) continue block6;
                        ByteBuffer result = this.coalesce(buffers);
                        this.stream.data(new DataFrame(this.stream.getId(), result, false), pending);
                        break block6;
                    }
                    case 1: {
                        callback.failed(new WritePendingException());
                        break block6;
                    }
                    case 2: 
                    case 3: {
                        callback.failed(new EofException("Output shutdown"));
                        break block6;
                    }
                    case 4: {
                        callback.failed(current.failure);
                        break block6;
                    }
                    default: {
                        callback.failed(new IllegalStateException("Unexpected state: " + String.valueOf((Object)current.state)));
                    }
                }
                break;
            }
            return;
        }
        callback.succeeded();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Callback cancelWrite(Throwable cause) {
        do lbl-1000:
        // 4 sources

        {
            current = this.writeState.get();
            switch (current.state.ordinal()) {
                case 0: {
                    if (!this.writeState.compareAndSet(current, new WriteState(WriteState.State.FAILED, cause))) ** GOTO lbl-1000
                    this.stream.reset(new ResetFrame(this.stream.getId(), ErrorCode.CANCEL_STREAM_ERROR.code), Callback.NOOP);
                    return null;
                }
                case 1: 
                case 2: {
                    if (!this.writeState.compareAndSet(current, new WriteState(WriteState.State.FAILED, cause))) ** GOTO lbl-1000
                    pending = (WriteState.Pending)current;
                    this.stream.reset(new ResetFrame(this.stream.getId(), ErrorCode.CANCEL_STREAM_ERROR.code));
                    callbacks = new Callback.Combination(pending.callback, cause);
                    try {
                        this.stream.getSession().flush(callbacks.newCallback());
                        var5_5 = callbacks.newCallback();
                        return var5_5;
                    }
                    finally {
                        callbacks.close();
                    }
                }
                case 4: {
                    ExceptionUtil.addSuppressedIfNotAssociated(current.failure, cause);
                    return null;
                }
            }
        } while (!this.writeState.compareAndSet(current, new WriteState(WriteState.State.FAILED, cause)));
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private void writeSuccess() {
        block4: while (true) {
            current = this.writeState.get();
            switch (current.state.ordinal()) {
                case 1: {
                    if (!this.writeState.compareAndSet(current, WriteState.IDLE)) continue block4;
                    ((WriteState.Pending)current).callback.succeeded();
                    break block4;
                }
                case 2: {
                    if (this.writeState.compareAndSet(current, WriteState.OSHUT)) ** break;
                    continue block4;
                    ((WriteState.Pending)current).callback.succeeded();
                    this.stream.data(new DataFrame(this.stream.getId(), BufferUtil.EMPTY_BUFFER, true), Callback.NOOP);
                }
            }
            break;
        }
    }

    private void writeFailure(Throwable failure) {
        block3: while (true) {
            WriteState current = this.writeState.get();
            switch (current.state.ordinal()) {
                case 1: 
                case 2: {
                    if (!this.writeState.compareAndSet(current, new WriteState(WriteState.State.FAILED, failure))) continue block3;
                    ((WriteState.Pending)current).callback.failed(failure);
                }
            }
            break;
        }
    }

    private long remaining(ByteBuffer ... buffers) {
        return BufferUtil.remaining(buffers);
    }

    private ByteBuffer coalesce(ByteBuffer[] buffers) {
        if (buffers.length == 1) {
            return buffers[0];
        }
        long capacity = this.remaining(buffers);
        if (capacity > Integer.MAX_VALUE) {
            throw new BufferOverflowException();
        }
        ByteBuffer result = BufferUtil.allocateDirect((int)capacity);
        for (ByteBuffer buffer : buffers) {
            BufferUtil.append(result, buffer);
        }
        return result;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    @Override
    public void onOpen() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onOpen {}", (Object)this);
        }
    }

    @Override
    public void onClose(Throwable cause) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onClose {}", (Object)this);
        }
    }

    @Override
    public void upgrade(Connection newConnection) {
        Connection oldConnection = this.getConnection();
        ByteBuffer buffer = null;
        if (oldConnection instanceof Connection.UpgradeFrom) {
            buffer = ((Connection.UpgradeFrom)((Object)oldConnection)).onUpgradeFrom();
        }
        if (oldConnection != null) {
            oldConnection.onClose(null);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("upgrading from {} to {} with data {} on {}", oldConnection, newConnection, BufferUtil.toDetailString(buffer), this);
        }
        this.setConnection(newConnection);
        if (newConnection instanceof Connection.UpgradeTo && buffer != null) {
            ((Connection.UpgradeTo)((Object)newConnection)).onUpgradeTo(buffer);
        }
        newConnection.onOpen();
    }

    protected void processDataAvailable() {
        this.process();
    }

    protected void processFailure(Throwable failure) {
        if (this.failure.compareAndSet(null, failure)) {
            this.process();
        }
    }

    private void process() {
        Callback callback = this.readCallback.getAndSet(null);
        if (callback != null) {
            callback.succeeded();
        }
    }

    @Override
    public Invocable.InvocationType getInvocationType() {
        Callback callback = this.readCallback.get();
        return callback == null ? Invocable.InvocationType.NON_BLOCKING : callback.getInvocationType();
    }

    public String toString() {
        return String.format("%s@%x[%s@%x#%d][w=%s]", TypeUtil.toShortName(this.getClass()), this.hashCode(), TypeUtil.toShortName(this.stream.getClass()), this.stream.hashCode(), this.stream.getId(), this.writeState);
    }

    private static class WriteState {
        public static final WriteState IDLE = new WriteState(State.IDLE);
        public static final WriteState OSHUT = new WriteState(State.OSHUT);
        private final State state;
        private final Throwable failure;

        private WriteState(State state) {
            this(state, null);
        }

        private WriteState(State state, Throwable failure) {
            this.state = state;
            this.failure = failure;
        }

        public String toString() {
            return this.state.toString();
        }

        private static enum State {
            IDLE,
            PENDING,
            PENDING_OSHUT,
            OSHUT,
            FAILED;

        }

        private static class Pending
        extends WriteState
        implements Callback {
            private final HTTP2StreamEndPoint endpoint;
            private final Callback callback;

            private Pending(State state, HTTP2StreamEndPoint endPoint, Callback callback) {
                super(state);
                this.endpoint = endPoint;
                this.callback = callback;
            }

            @Override
            public void succeeded() {
                this.endpoint.writeSuccess();
            }

            @Override
            public void failed(Throwable x) {
                this.endpoint.writeFailure(x);
            }

            @Override
            public Invocable.InvocationType getInvocationType() {
                return this.callback.getInvocationType();
            }
        }
    }
}

