/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.http.pathmap;

import java.util.Objects;
import wiremock.org.eclipse.jetty.http.pathmap.PathSpec;
import wiremock.org.eclipse.jetty.util.TypeUtil;

public abstract class AbstractPathSpec
implements PathSpec {
    @Override
    public int compareTo(PathSpec other) {
        int diff = this.getGroup().ordinal() - other.getGroup().ordinal();
        if (diff != 0) {
            return diff;
        }
        diff = other.getSpecLength() - this.getSpecLength();
        if (diff != 0) {
            return diff;
        }
        diff = this.getDeclaration().compareTo(other.getDeclaration());
        if (diff != 0) {
            return diff;
        }
        return this.getClass().getName().compareTo(other.getClass().getName());
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.compareTo((AbstractPathSpec)obj) == 0;
    }

    public final int hashCode() {
        return Objects.hash(this.getGroup().ordinal(), this.getSpecLength(), this.getDeclaration(), this.getClass().getName());
    }

    public String toString() {
        return String.format("%s@%s{%s,%s}", new Object[]{TypeUtil.toShortName(this.getClass()), Integer.toHexString(this.hashCode()), this.getGroup(), this.getDeclaration()});
    }
}

