/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.http.content;

import java.time.Instant;
import java.util.Set;
import wiremock.org.eclipse.jetty.http.CompressedContentFormat;
import wiremock.org.eclipse.jetty.http.DateGenerator;
import wiremock.org.eclipse.jetty.http.EtagUtils;
import wiremock.org.eclipse.jetty.http.HttpField;
import wiremock.org.eclipse.jetty.http.HttpHeader;
import wiremock.org.eclipse.jetty.http.MimeTypes;
import wiremock.org.eclipse.jetty.http.content.HttpContent;
import wiremock.org.eclipse.jetty.io.ByteBufferPool;
import wiremock.org.eclipse.jetty.io.Content;
import wiremock.org.eclipse.jetty.io.IOResources;
import wiremock.org.eclipse.jetty.util.Callback;
import wiremock.org.eclipse.jetty.util.TypeUtil;
import wiremock.org.eclipse.jetty.util.resource.Resource;

public class ResourceHttpContent
implements HttpContent {
    final Resource _resource;
    final HttpField _contentType;
    final HttpField _etag;
    final ByteBufferPool.Sized _sizedBufferPool;

    public ResourceHttpContent(Resource resource, String contentType) {
        this(resource, contentType, null);
    }

    public ResourceHttpContent(Resource resource, String contentType, ByteBufferPool.Sized sizedByteBufferPool) {
        this._resource = resource;
        this._contentType = contentType == null ? null : new HttpField(HttpHeader.CONTENT_TYPE, contentType);
        this._etag = EtagUtils.createWeakEtagField(resource);
        this._sizedBufferPool = sizedByteBufferPool;
    }

    @Override
    public HttpField getContentType() {
        return this._contentType;
    }

    @Override
    public HttpField getContentEncoding() {
        return null;
    }

    @Override
    public String getCharacterEncoding() {
        return this._contentType == null ? null : MimeTypes.getCharsetFromContentType(this._contentType.getValue());
    }

    @Override
    public MimeTypes.Type getMimeType() {
        return this._contentType == null ? null : MimeTypes.CACHE.get(MimeTypes.getContentTypeWithoutCharset(this._contentType.getValue()));
    }

    @Override
    public Instant getLastModifiedInstant() {
        return this._resource.lastModified();
    }

    @Override
    public HttpField getLastModified() {
        Instant lm = this._resource.lastModified();
        return new HttpField(HttpHeader.LAST_MODIFIED, DateGenerator.formatDate(lm));
    }

    @Override
    public HttpField getETag() {
        return this._etag;
    }

    @Override
    public HttpField getContentLength() {
        long l = this.getContentLengthValue();
        return l == -1L ? null : new HttpField.LongValueHttpField(HttpHeader.CONTENT_LENGTH, l);
    }

    @Override
    public long getContentLengthValue() {
        return this._resource.length();
    }

    @Override
    public Resource getResource() {
        return this._resource;
    }

    public String toString() {
        return String.format("%s@%x{r=%s,ct=%s}", TypeUtil.toShortName(this.getClass()), this.hashCode(), this._resource, this._contentType);
    }

    @Override
    public void writeTo(Content.Sink sink, long offset, long length, Callback callback) {
        IOResources.copy(this._resource, sink, this._sizedBufferPool, offset, length, callback);
    }

    @Override
    public Set<CompressedContentFormat> getPreCompressedContentFormats() {
        return null;
    }
}

