/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.http;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import wiremock.org.eclipse.jetty.http.ComplianceViolation;

public class MultiPartCompliance
implements ComplianceViolation.Mode {
    public static final MultiPartCompliance RFC7578_STRICT = new MultiPartCompliance("RFC7578_STRICT", EnumSet.noneOf(Violation.class));
    public static final MultiPartCompliance RFC7578 = new MultiPartCompliance("RFC7578", EnumSet.of(Violation.CONTENT_TRANSFER_ENCODING, Violation.LF_LINE_TERMINATION));
    public static final MultiPartCompliance LEGACY = new MultiPartCompliance("LEGACY", EnumSet.complementOf(EnumSet.of(Violation.BASE64_TRANSFER_ENCODING)));
    private static final List<MultiPartCompliance> KNOWN_MODES = Arrays.asList(RFC7578, LEGACY);
    private static final AtomicInteger __custom = new AtomicInteger();
    private final String name;
    private final Set<Violation> violations;

    public static MultiPartCompliance valueOf(String name) {
        for (MultiPartCompliance compliance : KNOWN_MODES) {
            if (!compliance.getName().equals(name)) continue;
            return compliance;
        }
        return null;
    }

    public static MultiPartCompliance from(Set<Violation> violations) {
        return new MultiPartCompliance("CUSTOM" + __custom.getAndIncrement(), violations);
    }

    public static MultiPartCompliance from(String spec) {
        MultiPartCompliance compliance = MultiPartCompliance.valueOf(spec);
        if (compliance == null) {
            String[] elements = spec.split("\\s*,\\s*");
            EnumSet<Violation> violations = switch (elements[0]) {
                case "0" -> EnumSet.noneOf(Violation.class);
                case "*" -> EnumSet.allOf(Violation.class);
                default -> {
                    MultiPartCompliance mode = MultiPartCompliance.valueOf(elements[0]);
                    if (mode == null) {
                        yield EnumSet.noneOf(Violation.class);
                    }
                    yield MultiPartCompliance.copyOf(mode.getAllowed());
                }
            };
            for (int i = 1; i < elements.length; ++i) {
                String element = elements[i];
                boolean exclude = element.startsWith("-");
                if (exclude) {
                    element = element.substring(1);
                }
                Violation section = Violation.valueOf(element);
                if (exclude) {
                    violations.remove(section);
                    continue;
                }
                violations.add(section);
            }
            compliance = new MultiPartCompliance("CUSTOM" + __custom.getAndIncrement(), violations);
        }
        return compliance;
    }

    private static Set<Violation> copyOf(Set<Violation> violations) {
        if (violations == null || violations.isEmpty()) {
            return EnumSet.noneOf(Violation.class);
        }
        return EnumSet.copyOf(violations);
    }

    public MultiPartCompliance(String name, Set<Violation> violations) {
        this.name = name;
        this.violations = violations;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean allows(ComplianceViolation violation) {
        return this.violations.contains(violation);
    }

    public Set<Violation> getKnown() {
        return EnumSet.allOf(Violation.class);
    }

    public Set<Violation> getAllowed() {
        return this.violations;
    }

    public String toString() {
        if (this == RFC7578 || this == LEGACY) {
            return this.name;
        }
        return String.format("%s@%x(v=%s)", this.name, this.hashCode(), this.violations);
    }

    public static enum Violation implements ComplianceViolation
    {
        CONTENT_TRANSFER_ENCODING("https://tools.ietf.org/html/rfc7578#section-4.7", "Content-Transfer-Encoding header is deprecated"),
        CR_LINE_TERMINATION("https://tools.ietf.org/html/rfc2046#section-4.1.1", "CR only line termination is forbidden"),
        LF_LINE_TERMINATION("https://tools.ietf.org/html/rfc2046#section-4.1.1", "LF only line termination is forbidden"),
        WHITESPACE_BEFORE_BOUNDARY("https://tools.ietf.org/html/rfc2046#section-5.1.1", "Whitespace not allowed before boundary"),
        BASE64_TRANSFER_ENCODING("https://tools.ietf.org/html/rfc7578#section-4.7", "'base64' Content-Transfer-Encoding is deprecated"),
        QUOTED_PRINTABLE_TRANSFER_ENCODING("https://tools.ietf.org/html/rfc7578#section-4.7", "'quoted-printable' Content-Transfer-Encoding is deprecated");

        private final String url;
        private final String description;

        private Violation(String url, String description) {
            this.url = url;
            this.description = description;
        }

        @Override
        public String getName() {
            return this.name();
        }

        @Override
        public String getURL() {
            return this.url;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

