/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.ee11.servlet.internal;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import wiremock.jakarta.servlet.WriteListener;
import wiremock.org.eclipse.jetty.ee11.servlet.HttpOutput;
import wiremock.org.eclipse.jetty.ee11.servlet.util.ServletOutputStreamWrapper;

public class UpgradedServletOutputStream
extends ServletOutputStreamWrapper {
    private final CompletableFuture<Void> _outputStreamComplete = new CompletableFuture();

    public UpgradedServletOutputStream(HttpOutput servletChannel) {
        super(servletChannel);
    }

    public CompletableFuture<Void> getCompletableFuture() {
        return this._outputStreamComplete;
    }

    @Override
    public void write(int b) throws IOException {
        try {
            super.write(b);
        }
        catch (Throwable t) {
            this._outputStreamComplete.completeExceptionally(t);
            throw t;
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        try {
            super.write(b);
        }
        catch (Throwable t) {
            this._outputStreamComplete.completeExceptionally(t);
            throw t;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            super.write(b, off, len);
        }
        catch (Throwable t) {
            this._outputStreamComplete.completeExceptionally(t);
            throw t;
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            super.flush();
        }
        catch (Throwable t) {
            this._outputStreamComplete.completeExceptionally(t);
            throw t;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
            this._outputStreamComplete.complete(null);
        }
        catch (Throwable t) {
            this._outputStreamComplete.completeExceptionally(t);
            throw t;
        }
    }

    @Override
    public void setWriteListener(final WriteListener writeListener) {
        super.setWriteListener(new WriteListener(){
            final /* synthetic */ UpgradedServletOutputStream this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onWritePossible() throws IOException {
                writeListener.onWritePossible();
            }

            @Override
            public void onError(Throwable t) {
                writeListener.onError(t);
                this.this$0._outputStreamComplete.completeExceptionally(t);
            }
        });
    }
}

