/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.ee11.servlet;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import wiremock.jakarta.servlet.DispatcherType;
import wiremock.jakarta.servlet.ServletResponse;
import wiremock.jakarta.servlet.ServletResponseWrapper;
import wiremock.jakarta.servlet.http.HttpSession;
import wiremock.org.eclipse.jetty.ee11.servlet.HttpOutput;
import wiremock.org.eclipse.jetty.ee11.servlet.ResponseWriter;
import wiremock.org.eclipse.jetty.ee11.servlet.ServletApiResponse;
import wiremock.org.eclipse.jetty.ee11.servlet.ServletChannel;
import wiremock.org.eclipse.jetty.ee11.servlet.ServletChannelState;
import wiremock.org.eclipse.jetty.ee11.servlet.ServletContextHandler;
import wiremock.org.eclipse.jetty.ee11.servlet.ServletContextRequest;
import wiremock.org.eclipse.jetty.ee11.servlet.SessionHandler;
import wiremock.org.eclipse.jetty.http.HttpCookie;
import wiremock.org.eclipse.jetty.http.HttpField;
import wiremock.org.eclipse.jetty.http.HttpFields;
import wiremock.org.eclipse.jetty.http.HttpGenerator;
import wiremock.org.eclipse.jetty.http.HttpHeader;
import wiremock.org.eclipse.jetty.http.HttpHeaderValue;
import wiremock.org.eclipse.jetty.http.HttpVersion;
import wiremock.org.eclipse.jetty.http.MimeTypes;
import wiremock.org.eclipse.jetty.server.Response;
import wiremock.org.eclipse.jetty.server.handler.ContextResponse;
import wiremock.org.eclipse.jetty.session.ManagedSession;
import wiremock.org.eclipse.jetty.util.Callback;
import wiremock.org.eclipse.jetty.util.StringUtil;

public class ServletContextResponse
extends ContextResponse
implements ServletContextHandler.ServletResponseInfo {
    private final ServletChannel _servletChannel;
    private final ServletApiResponse _servletApiResponse;
    private final HttpFields.Mutable.Wrapper _headers;
    private String _characterEncoding;
    private String _contentType;
    private MimeTypes.Type _mimeType;
    private Locale _locale;
    private EncodingFrom _encodingFrom = EncodingFrom.NOT_SET;
    private OutputType _outputType = OutputType.NONE;
    private ResponseWriter _writer;
    private Supplier<Map<String, String>> _trailers;

    public static ServletContextResponse getServletContextResponse(ServletResponse response) {
        if (response instanceof ServletApiResponse) {
            ServletApiResponse servletApiResponse = (ServletApiResponse)response;
            return servletApiResponse.getServletRequestInfo().getServletChannel().getServletContextResponse();
        }
        while (response instanceof ServletResponseWrapper) {
            if (!((response = ((ServletResponseWrapper)response).getResponse()) instanceof ServletApiResponse)) continue;
            ServletApiResponse servletApiResponse = (ServletApiResponse)response;
            return servletApiResponse.getServletRequestInfo().getServletChannel().getServletContextResponse();
        }
        throw new IllegalStateException("could not find %s for %s".formatted(ServletContextResponse.class.getSimpleName(), response));
    }

    public ServletContextResponse(ServletChannel servletChannel, ServletContextRequest request, Response response) {
        super(servletChannel.getContext(), request, response);
        this._servletChannel = servletChannel;
        this._servletApiResponse = this.newServletApiResponse();
        this._headers = new HttpFieldsWrapper(response.getHeaders());
    }

    @Override
    public Response getResponse() {
        return this._servletChannel.getResponse();
    }

    @Override
    public ResponseWriter getWriter() {
        return this._writer;
    }

    @Override
    public void setWriter(ResponseWriter writer) {
        this._writer = writer;
    }

    @Override
    public Locale getLocale() {
        return this._locale;
    }

    @Override
    public void setLocale(Locale locale) {
        this._locale = locale;
    }

    @Override
    public EncodingFrom getEncodingFrom() {
        return this._encodingFrom;
    }

    protected MimeTypes.Type getMimeType() {
        return this._mimeType;
    }

    @Override
    public Supplier<Map<String, String>> getTrailers() {
        return this._trailers;
    }

    @Override
    public void setTrailers(Supplier<Map<String, String>> trailers) {
        this._trailers = trailers;
    }

    @Override
    public String getCharacterEncoding() {
        return this._characterEncoding;
    }

    @Override
    public void setOutputType(OutputType outputType) {
        this._outputType = outputType;
    }

    @Override
    public String getContentType() {
        return this._contentType;
    }

    @Override
    public OutputType getOutputType() {
        return this._outputType;
    }

    protected ServletContextRequest getServletContextRequest() {
        return (ServletContextRequest)this.getRequest();
    }

    protected ServletApiResponse newServletApiResponse() {
        if (this._servletChannel.getServletContextHandler().isCrossContextDispatchSupported() && DispatcherType.INCLUDE.toString().equals(this.getRequest().getContext().getCrossContextDispatchType(this.getRequest()))) {
            return new ServletApiResponse.CrossContextInclude(this);
        }
        return new ServletApiResponse(this);
    }

    public HttpOutput getHttpOutput() {
        return this._servletChannel.getHttpOutput();
    }

    public ServletChannelState getServletRequestState() {
        return this._servletChannel.getServletRequestState();
    }

    public ServletApiResponse getServletApiResponse() {
        return this._servletApiResponse;
    }

    public void resetForForward() {
        this._servletApiResponse.resetBuffer();
        this._outputType = OutputType.NONE;
    }

    public void included() {
        if (this._outputType == OutputType.WRITER) {
            this._writer.reopen();
        }
        this.getHttpOutput().reopen();
    }

    public void completeOutput(Callback callback) {
        if (this._outputType == OutputType.WRITER) {
            this._writer.markAsClosed();
        }
        this.getHttpOutput().complete(callback);
    }

    @Override
    public HttpFields.Mutable getHeaders() {
        return this._headers;
    }

    @Override
    public void write(boolean last, ByteBuffer content, Callback callback) {
        super.write(last, content, callback);
    }

    public void closeOutput() throws IOException {
        if (this._outputType == OutputType.WRITER) {
            this._writer.close();
        } else {
            this.getHttpOutput().close();
        }
    }

    @Override
    public void reset() {
        SessionHandler sh;
        super.reset();
        this._servletApiResponse.resetBuffer();
        this._outputType = OutputType.NONE;
        this._contentType = null;
        this._mimeType = null;
        this._characterEncoding = null;
        this._encodingFrom = EncodingFrom.NOT_SET;
        this._trailers = null;
        HttpFields.Mutable headers = this.getHeaders();
        headers.clear();
        for (String value : this.getRequest().getHeaders().getCSV(HttpHeader.CONNECTION, false)) {
            HttpHeaderValue cb = HttpHeaderValue.CACHE.get(value);
            if (cb == null) continue;
            switch (cb) {
                case CLOSE: {
                    headers.put(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE.toString());
                    break;
                }
                case KEEP_ALIVE: {
                    if (!HttpVersion.HTTP_1_0.is(this.getRequest().getConnectionMetaData().getProtocol())) break;
                    headers.put(HttpHeader.CONNECTION, HttpHeaderValue.KEEP_ALIVE.toString());
                    break;
                }
                case TE: {
                    headers.put(HttpHeader.CONNECTION, HttpHeaderValue.TE.toString());
                    break;
                }
            }
        }
        HttpSession session = this.getServletContextRequest().getServletApiRequest().getSession(false);
        if (session != null && session.isNew() && (sh = this._servletChannel.getServletContextHandler().getSessionHandler()) != null) {
            ManagedSession managedSession = SessionHandler.ServletSessionApi.getSession(session);
            if (managedSession != null) {
                HttpCookie c = sh.getSessionCookie(managedSession, this.getRequest().isSecure());
                if (c != null) {
                    Response.putCookie(this.getWrapped(), c);
                }
            } else {
                throw new IllegalStateException();
            }
        }
    }

    public void resetContent() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Committed");
        }
        this.getHttpOutput().resetBuffer();
        this._outputType = OutputType.NONE;
        this._contentType = null;
        this._mimeType = null;
        this._characterEncoding = null;
        this._encodingFrom = EncodingFrom.NOT_SET;
        this.getHeaders().remove(this.getStatus() == 304 ? HttpHeader.CONTENT_HEADERS_304 : HttpHeader.CONTENT_HEADERS);
    }

    public String getRawCharacterEncoding() {
        return this._characterEncoding;
    }

    @Override
    public String getCharacterEncoding(boolean setContentType) {
        if (StringUtil.isNotBlank(this._characterEncoding) || this._encodingFrom == EncodingFrom.ASSUMED) {
            return this._characterEncoding.isEmpty() ? null : this._characterEncoding;
        }
        if (this._mimeType != null && this._mimeType.isCharsetAssumed()) {
            return this._mimeType.getCharsetString();
        }
        MimeTypes mimeTypes = this.getRequest().getContext().getMimeTypes();
        String encoding = mimeTypes.getAssumedCharsetName(this._contentType);
        if (encoding != null) {
            return encoding.isEmpty() ? null : encoding;
        }
        encoding = mimeTypes.getInferredCharsetName(this._contentType);
        if (encoding != null) {
            if (setContentType) {
                this.setCharacterEncoding(encoding, EncodingFrom.INFERRED);
            }
            return encoding;
        }
        ServletContextHandler.ServletContextApi context = this._servletChannel.getServletContextRequest().getServletContext().getServletContext();
        if (context != null && (encoding = context.getResponseCharacterEncoding()) != null) {
            if (setContentType) {
                this.setCharacterEncoding(encoding, EncodingFrom.DEFAULT);
            }
            return encoding;
        }
        encoding = MimeTypes.ISO_8859_1;
        if (setContentType) {
            this.setCharacterEncoding(encoding, EncodingFrom.DEFAULT);
        }
        return encoding;
    }

    @Override
    public void setCharacterEncoding(String encoding, EncodingFrom from) {
        if (this.isWriting() || this.isCommitted()) {
            return;
        }
        if (encoding == null) {
            this._encodingFrom = EncodingFrom.NOT_SET;
            if (this._characterEncoding != null) {
                this._characterEncoding = null;
                if (this._mimeType != null) {
                    this._mimeType = this._mimeType.getBaseType();
                    this._contentType = this._mimeType.asString();
                    this.getWrapped().getHeaders().put(this._mimeType.getContentTypeField());
                } else if (this._contentType != null) {
                    this._contentType = MimeTypes.getContentTypeWithoutCharset(this._contentType);
                    this.getWrapped().getHeaders().put(HttpHeader.CONTENT_TYPE, this._contentType);
                }
            }
        } else {
            this._encodingFrom = from;
            String string = this._characterEncoding = HttpGenerator.__STRICT ? encoding : MimeTypes.normalizeCharset(encoding);
            if (this._mimeType != null) {
                this._contentType = this._mimeType.getBaseType().asString() + ";charset=" + this._characterEncoding;
                this._mimeType = MimeTypes.CACHE.get(this._contentType);
                if (this._mimeType == null || HttpGenerator.__STRICT) {
                    this.getWrapped().getHeaders().put(HttpHeader.CONTENT_TYPE, this._contentType);
                } else {
                    this.getWrapped().getHeaders().put(this._mimeType.getContentTypeField());
                }
            } else if (this._contentType != null) {
                this._contentType = MimeTypes.getContentTypeWithoutCharset(this._contentType) + ";charset=" + this._characterEncoding;
                this.getWrapped().getHeaders().put(HttpHeader.CONTENT_TYPE, this._contentType);
            }
        }
    }

    @Override
    public boolean isWriting() {
        return this._outputType == OutputType.WRITER;
    }

    public boolean isStreaming() {
        return this._outputType == OutputType.STREAM;
    }

    public boolean isWritingOrStreaming() {
        return this.isWriting() || this.isStreaming();
    }

    public static enum EncodingFrom {
        NOT_SET,
        DEFAULT,
        ASSUMED,
        INFERRED,
        SET_LOCALE,
        SET_CONTENT_TYPE,
        SET_CHARACTER_ENCODING;

    }

    public static enum OutputType {
        NONE,
        STREAM,
        WRITER;

    }

    private class HttpFieldsWrapper
    extends HttpFields.Mutable.Wrapper {
        public HttpFieldsWrapper(HttpFields.Mutable fields) {
            super(fields);
        }

        @Override
        public HttpField onAddField(HttpField field) {
            if (ServletContextResponse.this.isCommitted()) {
                return null;
            }
            if (field.getHeader() == null) {
                return super.onAddField(field);
            }
            return switch (field.getHeader()) {
                case HttpHeader.CONTENT_TYPE -> this.setContentType(field);
                default -> super.onAddField(field);
            };
        }

        @Override
        public boolean onRemoveField(HttpField field) {
            if (ServletContextResponse.this.isCommitted()) {
                return false;
            }
            if (field.getHeader() == HttpHeader.CONTENT_TYPE) {
                ServletContextResponse.this._contentType = null;
                ServletContextResponse.this._mimeType = null;
                if (!ServletContextResponse.this.isWriting()) {
                    ServletContextResponse.this._characterEncoding = switch (ServletContextResponse.this._encodingFrom.ordinal()) {
                        case 4, 6 -> ServletContextResponse.this._characterEncoding;
                        default -> {
                            ServletContextResponse.this._encodingFrom = EncodingFrom.NOT_SET;
                            yield null;
                        }
                    };
                }
            }
            return true;
        }

        @Override
        public HttpField onReplaceField(HttpField oldField, HttpField newField) {
            assert (oldField != null && newField != null);
            if (ServletContextResponse.this.isCommitted()) {
                return oldField;
            }
            if (newField.getHeader() == null) {
                return newField;
            }
            return newField.getHeader() == HttpHeader.CONTENT_TYPE ? this.setContentType(newField) : newField;
        }

        private HttpField setContentType(HttpField field) {
            EncodingFrom charsetFrom;
            String charset;
            block19: {
                MimeTypes mimeTypes;
                block18: {
                    ServletContextResponse.this._contentType = field.getValue();
                    ServletContextResponse.this._mimeType = MimeTypes.CACHE.get(ServletContextResponse.this._contentType);
                    String mimeType = ServletContextResponse.this._mimeType == null ? MimeTypes.getContentTypeWithoutCharset(ServletContextResponse.this._contentType) : ServletContextResponse.this._mimeType.asString();
                    mimeTypes = ServletContextResponse.this.getRequest().getContext().getMimeTypes();
                    if (ServletContextResponse.this._mimeType == null) {
                        if (mimeTypes.isCharsetAssumed(mimeType)) {
                            String assumed = mimeTypes.getAssumedCharsetName(mimeType);
                            if (assumed == null) {
                                charset = null;
                                charsetFrom = EncodingFrom.ASSUMED;
                            } else {
                                charset = assumed;
                                charsetFrom = EncodingFrom.ASSUMED;
                            }
                        } else {
                            charset = MimeTypes.getCharsetFromContentType(ServletContextResponse.this._contentType);
                            charsetFrom = EncodingFrom.SET_CONTENT_TYPE;
                        }
                    } else if (ServletContextResponse.this._mimeType.isCharsetAssumed()) {
                        charset = ServletContextResponse.this._mimeType.getCharsetString();
                        charsetFrom = EncodingFrom.ASSUMED;
                    } else {
                        charset = ServletContextResponse.this._mimeType.getCharsetString();
                        charsetFrom = EncodingFrom.SET_CONTENT_TYPE;
                    }
                    if (charset != null) break block18;
                    switch (ServletContextResponse.this._encodingFrom.ordinal()) {
                        case 0: 
                        case 2: 
                        case 3: {
                            String inferred = mimeTypes.getInferredCharsetName(ServletContextResponse.this._mimeType == null ? mimeType : ServletContextResponse.this._mimeType.getBaseType().asString());
                            if (inferred != null) {
                                charset = inferred;
                                charsetFrom = EncodingFrom.INFERRED;
                                ServletContextResponse.this._contentType = ServletContextResponse.this._contentType + ";charset=" + charset;
                                ServletContextResponse.this._mimeType = MimeTypes.CACHE.get(ServletContextResponse.this._contentType);
                                field = new HttpField(HttpHeader.CONTENT_TYPE, ServletContextResponse.this._contentType);
                            } else {
                                charsetFrom = EncodingFrom.NOT_SET;
                            }
                            break block19;
                        }
                        case 1: 
                        case 4: 
                        case 5: 
                        case 6: {
                            if (charsetFrom != EncodingFrom.ASSUMED || ServletContextResponse.this._encodingFrom == EncodingFrom.SET_CHARACTER_ENCODING) {
                                charset = ServletContextResponse.this._characterEncoding;
                                charsetFrom = ServletContextResponse.this._encodingFrom;
                                ServletContextResponse.this._contentType = ServletContextResponse.this._contentType + ";charset=" + charset;
                                ServletContextResponse.this._mimeType = MimeTypes.CACHE.get(ServletContextResponse.this._contentType);
                                field = new HttpField(HttpHeader.CONTENT_TYPE, ServletContextResponse.this._contentType);
                            }
                            break block19;
                        }
                        default: {
                            throw new IllegalStateException(ServletContextResponse.this._encodingFrom.toString());
                        }
                    }
                }
                if (ServletContextResponse.this.isWriting() && !charset.equalsIgnoreCase(ServletContextResponse.this._characterEncoding)) {
                    ServletContextResponse.this._contentType = MimeTypes.getContentTypeWithoutCharset(ServletContextResponse.this._contentType);
                    if (ServletContextResponse.this._characterEncoding != null && (ServletContextResponse.this._encodingFrom == EncodingFrom.DEFAULT || mimeTypes.isCharsetAssumed(ServletContextResponse.this._contentType) || ServletContextResponse.this._mimeType != null && !ServletContextResponse.this._mimeType.isCharsetAssumed())) {
                        ServletContextResponse.this._contentType = ServletContextResponse.this._contentType + ";charset=" + ServletContextResponse.this._characterEncoding;
                    }
                    ServletContextResponse.this._mimeType = MimeTypes.CACHE.get(ServletContextResponse.this._contentType);
                    field = new HttpField(HttpHeader.CONTENT_TYPE, ServletContextResponse.this._contentType);
                    charset = ServletContextResponse.this._characterEncoding;
                    charsetFrom = ServletContextResponse.this._encodingFrom;
                }
            }
            ServletContextResponse.this._characterEncoding = charset;
            ServletContextResponse.this._encodingFrom = charsetFrom;
            if (HttpGenerator.__STRICT || ServletContextResponse.this._mimeType == null) {
                return field;
            }
            ServletContextResponse.this._contentType = ServletContextResponse.this._mimeType.asString();
            return ServletContextResponse.this._mimeType.getContentTypeField();
        }
    }
}

