/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.ee11.servlet;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import wiremock.jakarta.servlet.Servlet;
import wiremock.jakarta.servlet.ServletContext;
import wiremock.jakarta.servlet.ServletException;
import wiremock.jakarta.servlet.UnavailableException;
import wiremock.jakarta.servlet.http.HttpServlet;
import wiremock.jakarta.servlet.http.HttpServletRequest;
import wiremock.jakarta.servlet.http.HttpServletRequestWrapper;
import wiremock.jakarta.servlet.http.HttpServletResponse;
import wiremock.org.eclipse.jetty.ee11.servlet.ServletContextHandler;
import wiremock.org.eclipse.jetty.ee11.servlet.ServletHandler;
import wiremock.org.eclipse.jetty.ee11.servlet.ServletHolder;
import wiremock.org.eclipse.jetty.ee11.servlet.ServletMapping;
import wiremock.org.eclipse.jetty.server.handler.ContextHandler;
import wiremock.org.eclipse.jetty.util.ArrayUtil;
import wiremock.org.eclipse.jetty.util.URIUtil;
import wiremock.org.eclipse.jetty.util.thread.AutoLock;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class Invoker
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(Invoker.class);
    private ContextHandler _contextHandler;
    private ServletHandler _servletHandler;
    private Map<String, String> _parameters;
    private boolean _nonContextServlets;
    private boolean _verbose;

    @Override
    public void init() {
        ServletContext servletContext = this.getServletContext();
        ServletContextHandler.ServletContextApi servletContextApi = (ServletContextHandler.ServletContextApi)servletContext;
        this._servletHandler = servletContextApi.getContext().getServletContextHandler().getServletHandler();
        this._contextHandler = servletContextApi.getContextHandler();
        Enumeration<String> e = this.getInitParameterNames();
        while (e.hasMoreElements()) {
            String param = e.nextElement();
            String value = this.getInitParameter(param);
            String lvalue = value.toLowerCase(Locale.ENGLISH);
            if ("nonContextServlets".equals(param)) {
                boolean bl = this._nonContextServlets = !value.isEmpty() && lvalue.startsWith("t");
            }
            if ("verbose".equals(param)) {
                this._verbose = !value.isEmpty() && lvalue.startsWith("t");
                continue;
            }
            if (this._parameters == null) {
                this._parameters = new HashMap<String, String>();
            }
            this._parameters.put(param, value);
        }
    }

    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletHolder holder;
        String servlet;
        String pathInfo;
        String servletPath;
        boolean included;
        block27: {
            included = false;
            servletPath = (String)request.getAttribute("wiremock.jakarta.servlet.include.servlet_path");
            if (servletPath == null) {
                servletPath = request.getServletPath();
            } else {
                included = true;
            }
            pathInfo = (String)request.getAttribute("wiremock.jakarta.servlet.include.path_info");
            if (pathInfo == null) {
                pathInfo = request.getPathInfo();
            }
            if ((servlet = pathInfo) == null || servlet.length() <= 1) {
                response.sendError(404);
                return;
            }
            int i0 = servlet.charAt(0) == '/' ? 1 : 0;
            int i1 = servlet.indexOf(47, i0);
            servlet = i1 < 0 ? servlet.substring(i0) : servlet.substring(i0, i1);
            ServletHolder[] holders = this._servletHandler.getServlets();
            holder = this.getHolder(holders, servlet);
            if (holder != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding servlet mapping for named servlet: {}:{}/*", (Object)servlet, (Object)URIUtil.addPaths(servletPath, servlet));
                }
                ServletMapping mapping = new ServletMapping();
                mapping.setServletName(servlet);
                mapping.setPathSpec(URIUtil.addPaths(servletPath, servlet) + "/*");
                this._servletHandler.setServletMappings(ArrayUtil.addToArray(this._servletHandler.getServletMappings(), mapping, ServletMapping.class));
            } else {
                if (servlet.endsWith(".class")) {
                    servlet = servlet.substring(0, servlet.length() - 6);
                }
                if (servlet.isEmpty()) {
                    response.sendError(404);
                    return;
                }
                try (AutoLock ignored = this._servletHandler.lock();){
                    ServletHandler.MappedServlet invokerEntry = this._servletHandler.getMappedServlet(servletPath);
                    String path = URIUtil.addPaths(servletPath, servlet);
                    ServletHandler.MappedServlet entry = this._servletHandler.getMappedServlet(path);
                    if (entry != null && !entry.equals(invokerEntry)) {
                        holder = entry.getServletHolder();
                        break block27;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Making new servlet={}  with path={}/*", (Object)servlet, (Object)path);
                    }
                    holder = this._servletHandler.addServletWithMapping(servlet, path + "/*");
                    if (this._parameters != null) {
                        holder.setInitParameters(this._parameters);
                    }
                    try {
                        holder.start();
                    }
                    catch (Exception e) {
                        LOG.debug("Unable to start {}", (Object)holder, (Object)e);
                        throw new UnavailableException(e.toString());
                    }
                    if (!this._nonContextServlets) {
                        Servlet s = holder.getServlet();
                        if (this._contextHandler.getClassLoader() != s.getClass().getClassLoader()) {
                            try {
                                holder.stop();
                            }
                            catch (Exception e) {
                                LOG.trace("IGNORED", e);
                            }
                            LOG.warn("Dynamic servlet {} not loaded from context {}", (Object)s, (Object)request.getContextPath());
                            throw new UnavailableException("Not in context");
                        }
                    }
                    if (this._verbose && LOG.isDebugEnabled()) {
                        LOG.debug("Dynamic load '{}' at {}", (Object)servlet, (Object)path);
                    }
                }
            }
        }
        if (holder != null) {
            holder.prepare(request, response);
            holder.handle(new InvokedRequest(request, included, servlet, servletPath, pathInfo), response);
        } else {
            LOG.info("Can't find holder for servlet: {}", (Object)servlet);
            response.sendError(404);
        }
    }

    private ServletHolder getHolder(ServletHolder[] holders, String servlet) {
        if (holders == null) {
            return null;
        }
        ServletHolder holder = null;
        for (int i = 0; holder == null && i < holders.length; ++i) {
            if (!holders[i].getName().equals(servlet)) continue;
            holder = holders[i];
        }
        return holder;
    }

    static class InvokedRequest
    extends HttpServletRequestWrapper {
        String _servletPath;
        String _pathInfo;
        boolean _included;

        InvokedRequest(HttpServletRequest request, boolean included, String name, String servletPath, String pathInfo) {
            super(request);
            this._included = included;
            this._servletPath = URIUtil.addPaths(servletPath, name);
            this._pathInfo = pathInfo.substring(name.length() + 1);
            if (this._pathInfo.isEmpty()) {
                this._pathInfo = null;
            }
        }

        @Override
        public String getServletPath() {
            if (this._included) {
                return super.getServletPath();
            }
            return this._servletPath;
        }

        @Override
        public String getPathInfo() {
            if (this._included) {
                return super.getPathInfo();
            }
            return this._pathInfo;
        }

        @Override
        public Object getAttribute(String name) {
            if (this._included) {
                return switch (name) {
                    case "wiremock.jakarta.servlet.include.request_uri" -> URIUtil.addPaths(URIUtil.addPaths(this.getContextPath(), this._servletPath), this._pathInfo);
                    case "wiremock.jakarta.servlet.include.path_info" -> this._pathInfo;
                    case "wiremock.jakarta.servlet.include.servlet_path" -> this._servletPath;
                    default -> super.getAttribute(name);
                };
            }
            return super.getAttribute(name);
        }
    }
}

