/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.ee11.servlet;

import java.io.Closeable;
import java.io.IOException;
import java.util.Set;
import wiremock.jakarta.servlet.DispatcherType;
import wiremock.jakarta.servlet.RequestDispatcher;
import wiremock.jakarta.servlet.ServletException;
import wiremock.jakarta.servlet.ServletRequest;
import wiremock.jakarta.servlet.ServletResponse;
import wiremock.jakarta.servlet.http.HttpServletRequest;
import wiremock.jakarta.servlet.http.HttpServletResponse;
import wiremock.org.eclipse.jetty.ee11.servlet.CrossContextServletContext;
import wiremock.org.eclipse.jetty.ee11.servlet.ServletContextRequest;
import wiremock.org.eclipse.jetty.ee11.servlet.ServletCoreRequest;
import wiremock.org.eclipse.jetty.ee11.servlet.ServletCoreResponse;
import wiremock.org.eclipse.jetty.ee11.servlet.ServletRequestHttpWrapper;
import wiremock.org.eclipse.jetty.ee11.servlet.ServletResponseHttpWrapper;
import wiremock.org.eclipse.jetty.http.HttpURI;
import wiremock.org.eclipse.jetty.server.Request;
import wiremock.org.eclipse.jetty.server.handler.ContextHandler;
import wiremock.org.eclipse.jetty.util.Attributes;
import wiremock.org.eclipse.jetty.util.Blocker;
import wiremock.org.eclipse.jetty.util.IO;

class CrossContextDispatcher
implements RequestDispatcher {
    public static final String ORIGINAL_URI = "wiremock.org.eclipse.jetty.dispatch.originalURI";
    public static final String ORIGINAL_QUERY_STRING = "wiremock.org.eclipse.jetty.dispatch.originalQueryString";
    public static final String ORIGINAL_SERVLET_MAPPING = "wiremock.org.eclipse.jetty.dispatch.originalServletMapping";
    public static final String ORIGINAL_CONTEXT_PATH = "wiremock.org.eclipse.jetty.dispatch.originalContextPath";
    public static final Set<String> ATTRIBUTES = Set.of("wiremock.jakarta.servlet.forward.request_uri", "wiremock.jakarta.servlet.forward.mapping", "wiremock.jakarta.servlet.forward.context_path", "wiremock.jakarta.servlet.forward.servlet_path", "wiremock.jakarta.servlet.forward.query_string", "wiremock.jakarta.servlet.forward.path_info", "wiremock.jakarta.servlet.include.request_uri", "wiremock.jakarta.servlet.include.mapping", "wiremock.jakarta.servlet.include.context_path", "wiremock.jakarta.servlet.include.servlet_path", "wiremock.jakarta.servlet.include.query_string", "wiremock.jakarta.servlet.include.path_info", "javax.servlet.include.request_uri", "javax.servlet.include.mapping", "javax.servlet.include.context_path", "javax.servlet.include.servlet_path", "javax.servlet.include.query_string", "javax.servlet.include.path_info", "wiremock.org.eclipse.jetty.multipartConfig", "wiremock.org.eclipse.jetty.CrossContextDispatch", "wiremock.org.eclipse.jetty.dispatch.originalURI", "wiremock.org.eclipse.jetty.dispatch.originalQueryString", "wiremock.org.eclipse.jetty.dispatch.originalServletMapping", "wiremock.org.eclipse.jetty.dispatch.originalContextPath");
    private final CrossContextServletContext _targetContext;
    private final HttpURI _uri;
    private final String _decodedPathInContext;

    CrossContextDispatcher(CrossContextServletContext targetContext, HttpURI uri, String decodedPathInContext) {
        this._targetContext = targetContext;
        this._uri = uri;
        this._decodedPathInContext = decodedPathInContext;
    }

    public void async(ServletRequest servletRequest, ServletResponse response) throws ServletException, IOException {
        HttpServletRequest httpServletRequest = servletRequest instanceof HttpServletRequest ? (HttpServletRequest)servletRequest : new ServletRequestHttpWrapper(servletRequest);
        HttpServletResponse httpResponse = response instanceof HttpServletResponse ? (HttpServletResponse)response : new ServletResponseHttpWrapper(response);
        AsyncRequest asyncRequest = new AsyncRequest(httpServletRequest);
        try (Blocker.Callback callback = Blocker.callback();){
            ((ContextHandler)this._targetContext.getTargetContext().getContextHandler()).handle(asyncRequest, new ServletCoreResponse(asyncRequest, httpResponse, false), callback);
            callback.block();
        }
        catch (Exception e) {
            throw new ServletException(e);
        }
    }

    @Override
    public void forward(ServletRequest servletRequest, ServletResponse response) throws ServletException, IOException {
        HttpServletRequest httpServletRequest = servletRequest instanceof HttpServletRequest ? (HttpServletRequest)servletRequest : new ServletRequestHttpWrapper(servletRequest);
        HttpServletResponse httpResponse = response instanceof HttpServletResponse ? (HttpServletResponse)response : new ServletResponseHttpWrapper(response);
        ServletContextRequest servletContextRequest = ServletContextRequest.getServletContextRequest(servletRequest);
        servletContextRequest.getServletContextResponse().resetForForward();
        ForwardRequest forwardRequest = new ForwardRequest(httpServletRequest);
        try (Blocker.Callback callback = Blocker.callback();){
            ((ContextHandler)this._targetContext.getTargetContext().getContextHandler()).handle(forwardRequest, new ServletCoreResponse(forwardRequest, httpResponse, false), callback);
            callback.block();
        }
        catch (Exception e) {
            throw new ServletException(e);
        }
        if (!servletContextRequest.getState().isAsync() && !servletContextRequest.getServletContextResponse().hasLastWrite()) {
            Closeable closeable;
            try {
                closeable = response.getOutputStream();
            }
            catch (IllegalStateException e) {
                closeable = response.getWriter();
            }
            IO.close(closeable);
        }
    }

    @Override
    public void include(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        HttpServletRequest httpServletRequest = servletRequest instanceof HttpServletRequest ? (HttpServletRequest)servletRequest : new ServletRequestHttpWrapper(servletRequest);
        HttpServletResponse httpServletResponse = servletResponse instanceof HttpServletResponse ? (HttpServletResponse)servletResponse : new ServletResponseHttpWrapper(servletResponse);
        IncludeRequest includeRequest = new IncludeRequest(httpServletRequest);
        IncludeResponse includeResponse = new IncludeResponse(includeRequest, httpServletResponse);
        try (Blocker.Callback callback = Blocker.callback();){
            ((ContextHandler)this._targetContext.getTargetContext().getContextHandler()).handle(includeRequest, includeResponse, callback);
            callback.block();
        }
        catch (Exception e) {
            throw new ServletException(e);
        }
    }

    private class AsyncRequest
    extends ServletCoreRequest {
        private final HttpURI _fullyQualifiedURI;

        public AsyncRequest(HttpServletRequest httpServletRequest) {
            super(httpServletRequest, new ServletCoreRequest.ServletAttributes(httpServletRequest));
            this._fullyQualifiedURI = HttpURI.build(httpServletRequest.getRequestURL().toString()).pathQuery(CrossContextDispatcher.this._uri.getPathQuery()).asImmutable();
        }

        @Override
        public HttpURI getHttpURI() {
            return this._fullyQualifiedURI;
        }
    }

    private class ForwardRequest
    extends ServletCoreRequest {
        private final HttpURI _fullyQualifiedURI;

        public ForwardRequest(final HttpServletRequest httpServletRequest) {
            super(httpServletRequest, new Attributes.Synthetic(CrossContextDispatcher.this, new ServletCoreRequest.ServletAttributes(httpServletRequest)){
                final /* synthetic */ CrossContextDispatcher this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                }

                @Override
                protected Object getSyntheticAttribute(String name) {
                    if (name == null) {
                        return null;
                    }
                    if (((String)name).startsWith("javax.servlet.")) {
                        name = "wiremock.jakarta.servlet." + ((String)name).substring(14);
                    }
                    return switch (name) {
                        case "wiremock.jakarta.servlet.forward.request_uri" -> httpServletRequest.getRequestURI();
                        case "wiremock.jakarta.servlet.forward.servlet_path" -> httpServletRequest.getServletPath();
                        case "wiremock.jakarta.servlet.forward.path_info" -> httpServletRequest.getPathInfo();
                        case "wiremock.jakarta.servlet.forward.context_path" -> httpServletRequest.getContextPath();
                        case "wiremock.jakarta.servlet.forward.mapping" -> httpServletRequest.getHttpServletMapping();
                        case "wiremock.jakarta.servlet.forward.query_string" -> httpServletRequest.getQueryString();
                        case "wiremock.jakarta.servlet.include.mapping" -> REMOVED;
                        case "wiremock.jakarta.servlet.include.request_uri" -> REMOVED;
                        case "wiremock.jakarta.servlet.include.context_path" -> REMOVED;
                        case "wiremock.jakarta.servlet.include.query_string" -> REMOVED;
                        case "wiremock.jakarta.servlet.include.servlet_path" -> REMOVED;
                        case "wiremock.jakarta.servlet.include.path_info" -> REMOVED;
                        case "wiremock.org.eclipse.jetty.CrossContextDispatch" -> DispatcherType.FORWARD.toString();
                        default -> null;
                    };
                }

                @Override
                protected Set<String> getSyntheticNameSet() {
                    return ATTRIBUTES;
                }
            });
            this._fullyQualifiedURI = HttpURI.build(httpServletRequest.getRequestURL().toString()).pathQuery(CrossContextDispatcher.this._uri.getPathQuery()).asImmutable();
        }

        @Override
        public HttpURI getHttpURI() {
            return this._fullyQualifiedURI;
        }
    }

    private class IncludeRequest
    extends ServletCoreRequest {
        public IncludeRequest(final HttpServletRequest httpServletRequest) {
            super(httpServletRequest, new Attributes.Synthetic(CrossContextDispatcher.this, new ServletCoreRequest.ServletAttributes(httpServletRequest)){
                final /* synthetic */ CrossContextDispatcher this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                }

                @Override
                public Object getAttribute(String name) {
                    if (((String)name).startsWith("javax.servlet.")) {
                        name = "wiremock.jakarta.servlet." + ((String)name).substring(14);
                    }
                    return super.getAttribute((String)name);
                }

                @Override
                protected Object getSyntheticAttribute(String name) {
                    if (name == null) {
                        return null;
                    }
                    return switch (name) {
                        case "wiremock.jakarta.servlet.include.mapping" -> null;
                        case "wiremock.jakarta.servlet.include.servlet_path" -> null;
                        case "wiremock.jakarta.servlet.include.path_info" -> this.this$0._decodedPathInContext;
                        case "wiremock.jakarta.servlet.include.request_uri" -> {
                            if (this.this$0._uri == null) {
                                yield null;
                            }
                            yield this.this$0._uri.getPath();
                        }
                        case "wiremock.jakarta.servlet.include.context_path" -> this.this$0._targetContext.getContextPath();
                        case "wiremock.jakarta.servlet.include.query_string" -> {
                            if (this.this$0._uri == null) {
                                yield null;
                            }
                            yield this.this$0._uri.getQuery();
                        }
                        case "wiremock.org.eclipse.jetty.CrossContextDispatch" -> DispatcherType.INCLUDE.toString();
                        case CrossContextDispatcher.ORIGINAL_URI -> httpServletRequest.getRequestURI();
                        case CrossContextDispatcher.ORIGINAL_QUERY_STRING -> httpServletRequest.getQueryString();
                        case CrossContextDispatcher.ORIGINAL_SERVLET_MAPPING -> httpServletRequest.getHttpServletMapping();
                        case CrossContextDispatcher.ORIGINAL_CONTEXT_PATH -> httpServletRequest.getContextPath();
                        default -> httpServletRequest.getAttribute(name);
                    };
                }

                @Override
                protected Set<String> getSyntheticNameSet() {
                    return ATTRIBUTES;
                }

                @Override
                public Object setAttribute(String name, Object attribute) {
                    if (name == null) {
                        return null;
                    }
                    if (((String)name).startsWith("javax.servlet.")) {
                        name = "wiremock.jakarta.servlet." + ((String)name).substring(14);
                    }
                    return super.setAttribute((String)name, attribute);
                }
            });
        }

        @Override
        public HttpURI getHttpURI() {
            return CrossContextDispatcher.this._uri;
        }
    }

    private static class IncludeResponse
    extends ServletCoreResponse {
        public IncludeResponse(Request coreRequest, HttpServletResponse httpServletResponse) {
            super(coreRequest, httpServletResponse, true);
        }
    }
}

