/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.compression.gzip.internal;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import wiremock.org.eclipse.jetty.compression.EncoderSink;
import wiremock.org.eclipse.jetty.compression.gzip.GzipCompression;
import wiremock.org.eclipse.jetty.compression.gzip.GzipEncoderConfig;
import wiremock.org.eclipse.jetty.io.Content;
import wiremock.org.eclipse.jetty.io.Retainable;
import wiremock.org.eclipse.jetty.io.RetainableByteBuffer;
import wiremock.org.eclipse.jetty.util.BufferUtil;
import wiremock.org.eclipse.jetty.util.Callback;
import wiremock.org.eclipse.jetty.util.compression.CompressionPool;
import wiremock.org.eclipse.jetty.util.thread.Invocable;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class GzipEncoderSink
extends EncoderSink {
    private static final Logger LOG = LoggerFactory.getLogger(GzipEncoderSink.class);
    private static final byte OS_UNKNOWN = -1;
    private static final byte[] GZIP_HEADER = new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 0, -1};
    private final GzipCompression compression;
    private final CompressionPool.Entry deflaterEntry;
    private final Deflater deflater;
    private final RetainableByteBuffer inputBuffer;
    private final ByteBuffer input;
    private final int bufferSize;
    private final CRC32 crc = new CRC32();
    private final AtomicReference<State> state = new AtomicReference<State>(State.HEADERS);
    private boolean released;

    public GzipEncoderSink(GzipCompression compression, Content.Sink sink, GzipEncoderConfig config) {
        super(sink);
        this.compression = compression;
        this.deflaterEntry = compression.getDeflaterPool().acquire();
        this.deflater = (Deflater)this.deflaterEntry.get();
        this.bufferSize = config.getBufferSize();
        this.inputBuffer = compression.acquireByteBuffer(this.bufferSize);
        this.input = this.inputBuffer.getByteBuffer();
        this.input.position(this.input.limit());
        this.deflater.reset();
        this.deflater.setInput(this.input);
        this.deflater.setStrategy(config.getStrategy());
        this.deflater.setLevel(config.getCompressionLevel());
        this.crc.reset();
    }

    protected void addInput(ByteBuffer content) {
        int pos = BufferUtil.flipToFill(this.input);
        int space = Math.min(this.input.remaining(), content.remaining());
        ByteBuffer slice = content.slice();
        slice.limit(space);
        this.crc.update(slice.slice());
        this.input.put(slice);
        BufferUtil.flipToFlush(this.input, pos);
        content.position(content.position() + space);
    }

    @Override
    protected EncoderSink.WriteRecord encode(boolean last, ByteBuffer content) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("encode() last={}, content={}", (Object)last, (Object)BufferUtil.toDetailString(content));
        }
        if (this.released) {
            throw new IllegalStateException("Already released");
        }
        Retainable output = null;
        try {
            while (true) {
                switch (this.state.get().ordinal()) {
                    case 0: {
                        this.state.compareAndSet(State.HEADERS, State.BODY);
                        EncoderSink.WriteRecord writeRecord = new EncoderSink.WriteRecord(false, ByteBuffer.wrap(GZIP_HEADER), Callback.NOOP);
                        return writeRecord;
                    }
                    case 1: {
                        if (BufferUtil.hasContent(content)) {
                            if (output == null) {
                                output = this.compression.acquireByteBuffer(this.bufferSize);
                            }
                            if (!this.encode(content, output.getByteBuffer())) break;
                            EncoderSink.WriteRecord writeRecord = new EncoderSink.WriteRecord(false, output.getByteBuffer(), Callback.from(Invocable.InvocationType.NON_BLOCKING, ((RetainableByteBuffer)output)::release));
                            output = null;
                            EncoderSink.WriteRecord writeRecord2 = writeRecord;
                            return writeRecord2;
                        }
                        if (last) {
                            this.state.compareAndSet(State.BODY, State.FLUSHING);
                            this.deflater.finish();
                            break;
                        }
                        EncoderSink.WriteRecord writeRecord = null;
                        return writeRecord;
                    }
                    case 2: {
                        if (output == null) {
                            output = this.compression.acquireByteBuffer(this.bufferSize);
                        }
                        if (!this.flush(output.getByteBuffer())) {
                            this.state.compareAndSet(State.FLUSHING, State.TRAILERS);
                        }
                        if (!output.hasRemaining()) break;
                        EncoderSink.WriteRecord writeRecord = new EncoderSink.WriteRecord(false, output.getByteBuffer(), Callback.from(Invocable.InvocationType.NON_BLOCKING, ((RetainableByteBuffer)output)::release));
                        output = null;
                        EncoderSink.WriteRecord writeRecord3 = writeRecord;
                        return writeRecord3;
                    }
                    case 3: {
                        if (output == null) {
                            output = this.compression.acquireByteBuffer(16);
                        }
                        this.trailers(output.getByteBuffer());
                        this.state.compareAndSet(State.TRAILERS, State.FINISHED);
                        EncoderSink.WriteRecord writeRecord = new EncoderSink.WriteRecord(true, output.getByteBuffer(), Callback.from(Invocable.InvocationType.NON_BLOCKING, ((RetainableByteBuffer)output)::release));
                        output = null;
                        EncoderSink.WriteRecord writeRecord4 = writeRecord;
                        return writeRecord4;
                    }
                    case 4: {
                        EncoderSink.WriteRecord writeRecord = null;
                        return writeRecord;
                    }
                }
            }
        }
        finally {
            if (output != null) {
                output.release();
            }
        }
    }

    @Override
    protected void release() {
        if (this.released) {
            return;
        }
        this.released = true;
        this.inputBuffer.release();
        this.deflaterEntry.release();
    }

    private boolean encode(ByteBuffer content, ByteBuffer output) {
        if (content.hasRemaining()) {
            this.addInput(content);
        }
        BufferUtil.clearToFill(output);
        int len = this.deflater.deflate(output);
        BufferUtil.flipToFlush(output, 0);
        return len > 0;
    }

    private boolean flush(ByteBuffer output) {
        int pos = output.position();
        BufferUtil.flipToFill(output);
        while (!this.deflater.finished()) {
            int len = this.deflater.deflate(output, 3);
            if (len <= 0) continue;
            BufferUtil.flipToFlush(output, pos);
            return true;
        }
        BufferUtil.flipToFlush(output, pos);
        return false;
    }

    private void trailers(ByteBuffer output) {
        assert (output.order() == ByteOrder.LITTLE_ENDIAN);
        output.clear();
        output.putInt((int)this.crc.getValue());
        output.putInt(this.deflater.getTotalIn());
        output.flip();
    }

    static enum State {
        HEADERS,
        BODY,
        FLUSHING,
        TRAILERS,
        FINISHED;

    }
}

