/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.compression.gzip.internal;

import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;
import wiremock.org.eclipse.jetty.compression.DecoderSource;
import wiremock.org.eclipse.jetty.compression.gzip.GzipCompression;
import wiremock.org.eclipse.jetty.compression.gzip.GzipDecoderConfig;
import wiremock.org.eclipse.jetty.io.Content;
import wiremock.org.eclipse.jetty.util.BufferUtil;
import wiremock.org.eclipse.jetty.util.compression.CompressionPool;

public class GzipDecoderSource
extends DecoderSource {
    private static final long UINT_MAX = 0xFFFFFFFFL;
    private final GzipCompression compression;
    private final int bufferSize;
    private final CompressionPool.Entry inflaterEntry;
    private final Inflater inflater;
    private State state;
    private int size;
    private long value;
    private byte flags;

    public GzipDecoderSource(Content.Source source, GzipCompression compression, GzipDecoderConfig config) {
        super(source);
        this.compression = compression;
        this.inflaterEntry = compression.getInflaterPool().acquire();
        this.inflater = (Inflater)this.inflaterEntry.get();
        this.inflater.reset();
        this.bufferSize = config.getBufferSize();
        this.state = State.INITIAL;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Content.Chunk transform(Content.Chunk inputChunk) {
        compressed = inputChunk.getByteBuffer();
        block25: while (true) {
            block41: {
                block40: {
                    try {
                        block26: while (true) {
                            switch (this.state.ordinal()) {
                                case 0: {
                                    this.inflater.reset();
                                    this.state = State.ID;
                                    break block26;
                                }
                                case 7: {
                                    if ((this.flags & 4) == 4) {
                                        this.state = State.EXTRA_LENGTH;
                                        this.size = 0;
                                        this.value = 0L;
                                        break block26;
                                    }
                                    if ((this.flags & 8) == 8) {
                                        this.state = State.NAME;
                                        break block26;
                                    }
                                    if ((this.flags & 16) == 16) {
                                        this.state = State.COMMENT;
                                        break block26;
                                    }
                                    if ((this.flags & 2) == 2) {
                                        this.state = State.HCRC;
                                        this.size = 0;
                                        this.value = 0L;
                                        break block26;
                                    }
                                    this.state = State.DATA;
                                    continue block26;
                                }
                                case 13: {
                                    break block40;
                                }
                            }
                            break;
                        }
                        break block41;
                    }
                    catch (ZipException x) {
                        this.state = State.ERROR;
                        return Content.Chunk.from(x, true);
                    }
                }
                while (true) {
                    buffer = this.compression.acquireByteBuffer(this.bufferSize);
                    try {
                        decoded = buffer.getByteBuffer();
                        pos = BufferUtil.flipToFill(decoded);
                        this.inflater.inflate(decoded);
                        BufferUtil.flipToFlush(decoded, pos);
                        if (buffer.hasRemaining()) {
                            return Content.Chunk.asChunk(decoded, false, buffer);
                        }
                        buffer.release();
                    }
                    catch (DataFormatException x) {
                        buffer.release();
                        failure = new ZipException();
                        failure.initCause(x);
                        throw failure;
                    }
                    if (this.inflater.needsInput()) {
                        if (!compressed.hasRemaining()) {
                            return Content.Chunk.EMPTY;
                        }
                        this.inflater.setInput(compressed);
                        continue;
                    }
                    if (this.inflater.finished()) break;
                }
                this.state = State.CRC;
                this.size = 0;
                this.value = 0L;
                ** break;
            }
            if (inputChunk.isEmpty()) {
                if (inputChunk.isLast()) {
                    v0 = Content.Chunk.EOF;
                    return v0;
                }
                v0 = Content.Chunk.EMPTY;
                return v0;
            }
            currByte = compressed.get();
            switch (this.state.ordinal()) {
                case 16: 
                case 17: {
                    compressed.position(compressed.limit());
                    return Content.Chunk.EOF;
                }
                case 1: {
                    this.value += (long)(currByte & 255) << 8 * this.size;
                    ++this.size;
                    if (this.size != 2) continue block25;
                    if (this.value != 35615L) {
                        throw new ZipException("Invalid gzip bytes");
                    }
                    this.state = State.CM;
                    continue block25;
                }
                case 2: {
                    if ((currByte & 255) != 8) {
                        throw new ZipException("Invalid gzip compression method");
                    }
                    this.state = State.FLG;
                    continue block25;
                }
                case 3: {
                    this.flags = currByte;
                    this.state = State.MTIME;
                    this.size = 0;
                    this.value = 0L;
                    continue block25;
                }
                case 4: {
                    ++this.size;
                    if (this.size != 4) continue block25;
                    this.state = State.XFL;
                    continue block25;
                }
                case 5: {
                    this.state = State.OS;
                    continue block25;
                }
                case 6: {
                    this.state = State.FLAGS;
                    continue block25;
                }
                case 8: {
                    this.value += (long)(currByte & 255) << 8 * this.size;
                    ++this.size;
                    if (this.size != 2) continue block25;
                    this.state = State.EXTRA;
                    continue block25;
                }
                case 9: {
                    --this.value;
                    if (this.value != 0L) continue block25;
                    this.flags = (byte)(this.flags & -5);
                    this.state = State.FLAGS;
                    continue block25;
                }
                case 10: {
                    if (currByte != 0) continue block25;
                    this.flags = (byte)(this.flags & -9);
                    this.state = State.FLAGS;
                    continue block25;
                }
                case 11: {
                    if (currByte != 0) continue block25;
                    this.flags = (byte)(this.flags & -17);
                    this.state = State.FLAGS;
                    continue block25;
                }
                case 12: {
                    ++this.size;
                    if (this.size != 2) continue block25;
                    this.flags = (byte)(this.flags & -3);
                    this.state = State.FLAGS;
                    continue block25;
                }
                case 14: {
                    this.value += (long)(currByte & 255) << 8 * this.size;
                    ++this.size;
                    if (this.size != 4) continue block25;
                    this.state = State.ISIZE;
                    this.size = 0;
                    this.value = 0L;
                    continue block25;
                }
                case 15: {
                    this.value |= ((long)currByte & 255L) << 8 * this.size;
                    ++this.size;
                    if (this.size == 4) ** break;
                    continue block25;
                    if (this.value != (this.inflater.getBytesWritten() & 0xFFFFFFFFL)) {
                        throw new ZipException("Invalid input size");
                    }
                    this.state = State.INITIAL;
                    this.size = 0;
                    this.value = 0L;
                    return Content.Chunk.EOF;
                }
            }
            break;
        }
        throw new ZipException("Unknown state: " + String.valueOf((Object)this.state));
    }

    @Override
    protected void release() {
        super.release();
        this.inflaterEntry.release();
    }

    private static enum State {
        INITIAL,
        ID,
        CM,
        FLG,
        MTIME,
        XFL,
        OS,
        FLAGS,
        EXTRA_LENGTH,
        EXTRA,
        NAME,
        COMMENT,
        HCRC,
        DATA,
        CRC,
        ISIZE,
        FINISHED,
        ERROR;

    }
}

