/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.client.transport;

import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import wiremock.org.eclipse.jetty.client.Request;
import wiremock.org.eclipse.jetty.client.Response;
import wiremock.org.eclipse.jetty.client.transport.HttpExchange;
import wiremock.org.eclipse.jetty.client.transport.ResponseListeners;
import wiremock.org.eclipse.jetty.util.Attributes;
import wiremock.org.eclipse.jetty.util.Promise;
import wiremock.org.eclipse.jetty.util.TypeUtil;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class HttpConversation
extends Attributes.Lazy {
    private static final Logger LOG = LoggerFactory.getLogger(HttpConversation.class);
    private final Deque<HttpExchange> exchanges = new ConcurrentLinkedDeque<HttpExchange>();
    private volatile ResponseListeners listeners;

    public Deque<HttpExchange> getExchanges() {
        return this.exchanges;
    }

    public ResponseListeners getResponseListeners() {
        return this.listeners;
    }

    public void updateResponseListeners(Response.Listener overrideListener) {
        ResponseListeners listeners;
        HttpExchange lastExchange;
        HttpExchange firstExchange = this.exchanges.peekFirst();
        if (firstExchange == (lastExchange = this.exchanges.peekLast())) {
            listeners = overrideListener != null ? new ResponseListeners(overrideListener) : new ResponseListeners(firstExchange.getResponseListeners());
        } else {
            listeners = new ResponseListeners(lastExchange.getResponseListeners());
            if (overrideListener != null) {
                listeners.addListener(overrideListener);
            } else {
                listeners.addResponseListeners(firstExchange.getResponseListeners());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Exchanges in conversation {}, override={}, listeners={}", this.exchanges.size(), overrideListener, listeners);
        }
        this.listeners = listeners;
    }

    public boolean contains(Request request) {
        return this.getExchanges().stream().anyMatch(exchange -> exchange.getRequest() == request);
    }

    public long getTimeout() {
        HttpExchange firstExchange = this.exchanges.peekFirst();
        return firstExchange == null ? 0L : firstExchange.getRequest().getTimeout();
    }

    public void abort(Throwable cause, Promise<Boolean> promise) {
        HttpExchange exchange = this.exchanges.peekLast();
        if (exchange != null) {
            exchange.abort(cause, promise);
        } else {
            promise.succeeded(false);
        }
    }

    @Override
    public String toString() {
        return String.format("%s@%x[exchanges=%d]", TypeUtil.toShortName(this.getClass()), this.hashCode(), this.exchanges.size());
    }
}

