/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.client.transport;

import java.util.List;
import java.util.Map;
import wiremock.org.eclipse.jetty.client.transport.internal.HttpConnectionOverHTTP;
import wiremock.org.eclipse.jetty.io.ClientConnectionFactory;
import wiremock.org.eclipse.jetty.io.Connection;
import wiremock.org.eclipse.jetty.io.EndPoint;
import wiremock.org.eclipse.jetty.util.TypeUtil;

public class HttpClientConnectionFactory
implements ClientConnectionFactory {
    public static final ClientConnectionFactory.Info HTTP11 = new HTTP11();
    private boolean initializeConnections;

    public boolean isInitializeConnections() {
        return this.initializeConnections;
    }

    public void setInitializeConnections(boolean initialize) {
        this.initializeConnections = initialize;
    }

    @Override
    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) {
        HttpConnectionOverHTTP connection = new HttpConnectionOverHTTP(endPoint, context);
        connection.setInitialize(this.isInitializeConnections());
        return this.customize(connection, context);
    }

    public static class HTTP11
    extends ClientConnectionFactory.Info {
        private final List<String> protocols;

        public HTTP11() {
            this(List.of("http/1.1"));
        }

        public HTTP11(List<String> protocols) {
            super(new HttpClientConnectionFactory());
            this.protocols = protocols;
        }

        @Override
        public List<String> getProtocols(boolean secure) {
            return this.protocols;
        }

        @Override
        public String toString() {
            return String.format("%s@%x%s", TypeUtil.toShortName(this.getClass()), this.hashCode(), this.protocols);
        }
    }
}

